/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gui;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;

class MiniLogoPanel
extends JPanel {
    private static final long serialVersionUID = -199053265127458738L;

    MiniLogoPanel(String logoPath) throws IOException {
        this.setLayout(new FlowLayout(0));
        JLabel label = new JLabel("     Choose a PDF and a PDF flavour or a custom validation profile, then press \"Execute\"");
        label.setToolTipText("<html>PDF flavour: the PDF/A or PDF/UA part and conformance level<br>Validation profile: custom collection of validation rules</html>");
        try (InputStream is = this.getClass().getClassLoader().getResourceAsStream(logoPath);){
            BufferedImage image = ImageIO.read(is);
            VeraPDFIcon icon = new VeraPDFIcon(image);
            label.setIcon(icon);
        }
        this.add(label);
    }

    private static class VeraPDFIcon
    implements Icon {
        private static final double SCALE = 0.3;
        private final BufferedImage image;

        public VeraPDFIcon(BufferedImage image) {
            this.image = image;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            g.drawImage(this.image, 0, 0, this.getIconWidth(), this.getIconHeight(), 0, 0, this.image.getWidth(), this.image.getHeight(), null);
        }

        @Override
        public int getIconWidth() {
            return (int)((double)this.image.getWidth() * 0.3);
        }

        @Override
        public int getIconHeight() {
            return (int)((double)this.image.getHeight() * 0.3);
        }
    }
}

