/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.pd.colors;

import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSObject;
import org.verapdf.pd.colors.PDCIEDictionaryBased;
import org.verapdf.tools.TypeConverter;

public class PDCalRGB
extends PDCIEDictionaryBased {
    public PDCalRGB() {
    }

    public PDCalRGB(COSObject obj) {
        super(obj);
    }

    @Override
    public int getNumberOfComponents() {
        return 3;
    }

    @Override
    public ASAtom getType() {
        return ASAtom.CALRGB;
    }

    @Override
    public double[] toRGB(double[] value) {
        if (this.wpX == 1.0 && this.wpY == 1.0 && this.wpZ == 1.0) {
            double a = value[0];
            double b = value[1];
            double c = value[2];
            double[] gamma = this.getGamma();
            double powAR = Math.pow(a, gamma[0]);
            double powBG = Math.pow(b, gamma[1]);
            double powCB = Math.pow(c, gamma[2]);
            double[] matrix = this.getMatrix();
            double mXA = matrix[0];
            double mYA = matrix[1];
            double mZA = matrix[2];
            double mXB = matrix[3];
            double mYB = matrix[4];
            double mZB = matrix[5];
            double mXC = matrix[6];
            double mYC = matrix[7];
            double mZC = matrix[8];
            double x = mXA * powAR + mXB * powBG + mXC * powCB;
            double y = mYA * powAR + mYB * powBG + mYC * powCB;
            double z = mZA * powAR + mZB * powBG + mZC * powCB;
            return this.convXYZtoRGB(x, y, z);
        }
        return new double[]{value[0], value[1], value[2]};
    }

    public double[] getGamma() {
        double[] dArray;
        double[] res = TypeConverter.getRealArray(this.dictionary.getKey(ASAtom.GAMMA), 3, "Gamma");
        if (res != null) {
            dArray = res;
        } else {
            double[] dArray2 = new double[3];
            dArray2[0] = 1.0;
            dArray2[1] = 1.0;
            dArray = dArray2;
            dArray2[2] = 1.0;
        }
        return dArray;
    }

    public double[] getMatrix() {
        double[] dArray;
        double[] res = TypeConverter.getRealArray(this.dictionary.getKey(ASAtom.MATRIX), 9, "Matrix");
        if (res != null) {
            dArray = res;
        } else {
            double[] dArray2 = new double[9];
            dArray2[0] = 1.0;
            dArray2[1] = 0.0;
            dArray2[2] = 0.0;
            dArray2[3] = 0.0;
            dArray2[4] = 1.0;
            dArray2[5] = 0.0;
            dArray2[6] = 0.0;
            dArray2[7] = 0.0;
            dArray = dArray2;
            dArray2[8] = 1.0;
        }
        return dArray;
    }
}

