/*
 * Decompiled with CFR 0.152.
 */
package org.knopflerfish.framework;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.knopflerfish.framework.BundleCapabilityImpl;
import org.knopflerfish.framework.BundleClassLoader;
import org.knopflerfish.framework.BundleGeneration;
import org.knopflerfish.framework.BundleImpl;
import org.knopflerfish.framework.BundlePackages;
import org.knopflerfish.framework.BundleRequirementImpl;
import org.knopflerfish.framework.BundleRevisionImpl;
import org.knopflerfish.framework.BundleWireImpl;
import org.knopflerfish.framework.DTOId;
import org.knopflerfish.framework.ExportPkg;
import org.knopflerfish.framework.FrameworkContext;
import org.knopflerfish.framework.ImportPkg;
import org.knopflerfish.framework.RequireBundle;
import org.knopflerfish.framework.SystemBundle;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleRevision;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.framework.wiring.dto.BundleRevisionDTO;
import org.osgi.framework.wiring.dto.BundleWireDTO;
import org.osgi.framework.wiring.dto.BundleWiringDTO;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Wire;

public class BundleWiringImpl
extends DTOId
implements BundleWiring {
    final BundleRevisionImpl bundleRevision;

    BundleWiringImpl(BundleRevisionImpl br) {
        this.bundleRevision = br;
    }

    @Override
    public Bundle getBundle() {
        return this.bundleRevision.getBundle();
    }

    @Override
    public boolean isCurrent() {
        return this == this.bundleRevision.getWiring() && this.bundleRevision.bundle.current() == this.bundleRevision.gen;
    }

    @Override
    public boolean isInUse() {
        return this == this.bundleRevision.getWiring();
    }

    @Override
    public List<BundleCapability> getCapabilities(String namespace) {
        if (!this.isInUse()) {
            return null;
        }
        BundleGeneration gen = this.bundleRevision.getBundleGeneration();
        int ns = BundleRevisionImpl.whichNameSpaces(namespace);
        ArrayList<BundleCapability> res = new ArrayList<BundleCapability>();
        if ((ns & 4) != 0 && gen.identity != null) {
            res.add(gen.identity);
        }
        if (!gen.isFragment()) {
            if ((ns & 1) != 0 && gen.bundleCapability != null) {
                res.add(gen.bundleCapability);
            }
            if ((ns & 2) != 0 && gen.hostCapability != null) {
                res.add(gen.hostCapability);
            }
            if ((ns & 0x10) != 0) {
                for (ExportPkg ep : gen.bpkgs.getPackageCapabilities()) {
                    if (!ep.checkPermission()) continue;
                    res.add(ep);
                }
            }
            if ((ns & 0x28) != 0) {
                Map<String, List<BundleCapabilityImpl>> caps = gen.bpkgs.getOtherCapabilities();
                Collection<List<BundleCapabilityImpl>> clbc = null;
                if (null != namespace) {
                    List<BundleCapabilityImpl> lbc = caps.get(namespace);
                    if (lbc != null) {
                        clbc = Collections.singleton(lbc);
                    }
                } else {
                    clbc = caps.values();
                }
                if (null != clbc) {
                    for (List<BundleCapabilityImpl> lbc : clbc) {
                        for (BundleCapabilityImpl bc : lbc) {
                            if (!bc.isEffectiveResolve() || !bc.checkPermission()) continue;
                            res.add(bc);
                        }
                    }
                }
            }
        }
        return res;
    }

    @Override
    public List<BundleRequirement> getRequirements(String namespace) {
        if (!this.isInUse()) {
            return null;
        }
        BundleGeneration gen = this.bundleRevision.getBundleGeneration();
        int ns = BundleRevisionImpl.whichNameSpaces(namespace);
        ArrayList<BundleRequirement> res = new ArrayList<BundleRequirement>();
        if (gen.isFragment()) {
            if ((ns & 2) != 0) {
                res.add(gen.fragment);
            }
        } else {
            if ((ns & 1) != 0) {
                Iterator<RequireBundle> irb = gen.bpkgs.getRequire();
                while (irb.hasNext()) {
                    RequireBundle rb = irb.next();
                    if (null == rb.bpkgs || !rb.bpkgs.isRequiredBy(gen.bpkgs)) continue;
                    res.add(rb);
                }
            }
            if ((ns & 0x10) != 0) {
                res.addAll(gen.bpkgs.getPackageRequirements());
            }
            if ((ns & 8) != 0 && gen.nativeRequirement != null) {
                res.add(gen.nativeRequirement);
            }
            if ((ns & 0x24) != 0) {
                Map<String, List<BundleRequirementImpl>> reqs = gen.getOtherRequirements();
                Collection<List<BundleRequirementImpl>> clbr = null;
                if (null != namespace) {
                    List<BundleRequirementImpl> lbr = reqs.get(namespace);
                    if (lbr != null) {
                        clbr = Collections.singleton(lbr);
                    }
                } else {
                    clbr = reqs.values();
                }
                if (null != clbr) {
                    for (List<BundleRequirementImpl> lbr : clbr) {
                        for (BundleRequirementImpl br : lbr) {
                            if (!br.isWired()) continue;
                            res.add(br);
                        }
                    }
                }
            }
        }
        return res;
    }

    @Override
    public List<BundleWire> getProvidedWires(String namespace) {
        List<BundleWireImpl> other;
        if (!this.isInUse()) {
            return null;
        }
        BundleGeneration gen = this.bundleRevision.getBundleGeneration();
        int ns = BundleRevisionImpl.whichNameSpaces(namespace);
        ArrayList<BundleWire> res = new ArrayList<BundleWire>();
        if ((ns & 1) != 0) {
            List<BundlePackages> reqBys = gen.bpkgs.getRequiredBy();
            for (BundlePackages bp : reqBys) {
                Iterator<RequireBundle> irb = bp.getRequire();
                while (irb.hasNext()) {
                    RequireBundle rb = irb.next();
                    if (rb.bpkgs != gen.bpkgs) continue;
                    res.add(new BundleWireImpl(gen.bundleCapability, gen, rb, bp.bg));
                }
            }
        }
        if ((ns & 2) != 0 && gen.isFragmentHost()) {
            Vector fix = (Vector)gen.fragments.clone();
            for (BundleGeneration fbg : fix) {
                res.add(new BundleWireImpl(gen.hostCapability, gen, fbg.fragment, fbg));
            }
        }
        if ((ns & 0x10) != 0) {
            for (ExportPkg bc : gen.bpkgs.getPackageCapabilities()) {
                ExportPkg ep = bc;
                List<ImportPkg> ips = ep.getPackageImporters();
                if (ips == null) continue;
                for (ImportPkg ip : ips) {
                    ImportPkg oip = ip.parent != null && ip.parent.bpkgs != ip.bpkgs ? ip.parent : ip;
                    res.add(new BundleWireImpl(ep, gen, oip, ip.bpkgs.bg));
                }
            }
        }
        if ((ns & 8) != 0 && this.bundleRevision.gen.bundle.id == 0L) {
            FrameworkContext fc = this.bundleRevision.gen.bundle.fwCtx;
            SystemBundle sb = fc.systemBundle;
            for (BundleImpl bi : fc.bundles.getBundles()) {
                for (BundleGeneration bg : bi.generations) {
                    Set<BundleGeneration> nbgs;
                    ClassLoader cl = bg.getClassLoader();
                    if (cl == null || !(cl instanceof BundleClassLoader) || (nbgs = ((BundleClassLoader)cl).hasNativeRequirements()) == null) continue;
                    for (BundleGeneration nbg : nbgs) {
                        res.add(new BundleWireImpl(sb.getNativeCapability(), sb.current(), nbg.nativeRequirement, nbg));
                    }
                }
            }
        }
        if ((ns & 0x24) != 0 && (other = gen.getCapabilityWires()) != null) {
            for (BundleWireImpl bw : other) {
                if (namespace != null && !namespace.equals(bw.getCapability().getNamespace())) continue;
                res.add(bw);
            }
        }
        return res;
    }

    @Override
    public List<BundleWire> getRequiredWires(String namespace) {
        List<BundleWireImpl> other;
        Set<BundleGeneration> nbgs;
        ClassLoader cl;
        if (!this.isInUse()) {
            return null;
        }
        BundleGeneration gen = this.bundleRevision.getBundleGeneration();
        int ns = BundleRevisionImpl.whichNameSpaces(namespace);
        ArrayList<BundleWire> res = new ArrayList<BundleWire>();
        if ((ns & 1) != 0) {
            Iterator<RequireBundle> irb = gen.bpkgs.getRequire();
            while (irb.hasNext()) {
                RequireBundle rb = irb.next();
                if (null == rb.bpkgs || !rb.bpkgs.isRequiredBy(gen.bpkgs)) continue;
                res.add(new BundleWireImpl(rb.bpkgs.bg.bundleCapability, rb.bpkgs.bg, rb, gen));
            }
        }
        if ((ns & 2) != 0 && gen.isFragment()) {
            for (BundleGeneration hbg : gen.getHosts()) {
                res.add(new BundleWireImpl(hbg.hostCapability, hbg, gen.fragment, gen));
            }
        }
        if ((ns & 0x10) != 0) {
            TreeSet<ImportPkg> dynamic = new TreeSet<ImportPkg>(new Comparator<ImportPkg>(){

                @Override
                public int compare(ImportPkg o1, ImportPkg o2) {
                    return o1.dynId - o2.dynId;
                }
            });
            for (ImportPkg ip : gen.bpkgs.getPackageRequirements()) {
                ExportPkg ep = ip.provider;
                if (ep != null) {
                    res.add(new BundleWireImpl(ep, ep.bpkgs.bg, ip, gen));
                    continue;
                }
                for (ImportPkg cip : gen.bpkgs.getActiveChildImports(ip)) {
                    if (ip.isDynamic()) {
                        dynamic.add(cip);
                        continue;
                    }
                    res.add(new BundleWireImpl(cip.provider, cip.provider.bpkgs.bg, ip, gen));
                }
            }
            for (ImportPkg cip : dynamic) {
                res.add(new BundleWireImpl(cip.provider, cip.provider.bpkgs.bg, cip.parent, gen));
            }
        }
        if ((ns & 8) != 0 && (cl = gen.getClassLoader()) != null && cl instanceof BundleClassLoader && (nbgs = ((BundleClassLoader)cl).hasNativeRequirements()) != null) {
            SystemBundle sb = gen.bundle.fwCtx.systemBundle;
            for (BundleGeneration nbg : nbgs) {
                res.add(new BundleWireImpl(sb.getNativeCapability(), sb.current(), nbg.nativeRequirement, nbg));
            }
        }
        if ((ns & 0x2C) != 0 && (other = gen.getRequirementWires()) != null) {
            for (BundleWireImpl bw : other) {
                if (namespace != null && !namespace.equals(bw.getRequirement().getNamespace())) continue;
                res.add(bw);
            }
        }
        return res;
    }

    @Override
    public BundleRevision getRevision() {
        return this.bundleRevision;
    }

    @Override
    public ClassLoader getClassLoader() {
        if (this.isInUse()) {
            return this.bundleRevision.getBundleGeneration().getClassLoader();
        }
        return null;
    }

    @Override
    public List<URL> findEntries(String path, String filePattern, int options) {
        BundleGeneration gen = this.bundleRevision.getBundleGeneration();
        if (this.isInUse()) {
            return Collections.unmodifiableList(gen.bundle.secure.callFindEntries(gen, path, filePattern, (options & 1) != 0));
        }
        return null;
    }

    @Override
    public Collection<String> listResources(String path, String filePattern, int options) {
        BundleGeneration gen = this.bundleRevision.getBundleGeneration();
        if (!this.isInUse()) {
            return null;
        }
        Collection<Object> res = Collections.EMPTY_SET;
        ClassLoader cl = gen.getClassLoader();
        if (cl != null && cl instanceof BundleClassLoader) {
            BundleClassLoader bcl = (BundleClassLoader)gen.getClassLoader();
            res = bcl.listResources(path, filePattern, options);
        }
        return res;
    }

    @Override
    public List<Capability> getResourceCapabilities(String namespace) {
        return this.getCapabilities(namespace);
    }

    @Override
    public List<Requirement> getResourceRequirements(String namespace) {
        return this.getRequirements(namespace);
    }

    @Override
    public List<Wire> getProvidedResourceWires(String namespace) {
        return this.getProvidedWires(namespace);
    }

    @Override
    public List<Wire> getRequiredResourceWires(String namespace) {
        return this.getRequiredWires(namespace);
    }

    @Override
    public BundleRevision getResource() {
        return this.bundleRevision;
    }

    BundleWiringDTO getDTO() {
        BundleWiringDTO res = new BundleWiringDTO();
        res.bundle = this.bundleRevision.gen.bundle.id;
        res.root = this.dtoId;
        HashMap<BundleWiringImpl, BundleWiringDTO.NodeDTO> nodes = new HashMap<BundleWiringImpl, BundleWiringDTO.NodeDTO>();
        this.walkWires(nodes, null);
        res.nodes = new HashSet(nodes.values());
        res.resources = new HashSet<BundleRevisionDTO>();
        for (BundleWiringImpl bwi : nodes.keySet()) {
            res.resources.add(bwi.bundleRevision.getDTO());
        }
        return res;
    }

    void walkWires(Map<BundleWiringImpl, BundleWiringDTO.NodeDTO> nodes, BundleWireDTO wireDTO) {
        BundleWiringDTO.NodeDTO dto = nodes.get(this);
        if (dto == null) {
            boolean isRoot = nodes.isEmpty();
            dto = new BundleWiringDTO.NodeDTO();
            dto.inUse = this.isInUse();
            dto.current = this.isCurrent();
            dto.id = this.dtoId;
            dto.capabilities = this.bundleRevision.getCapabilityRefDTOs();
            dto.requirements = this.bundleRevision.getRequirementRefDTOs();
            dto.providedWires = new ArrayList();
            dto.requiredWires = new ArrayList();
            dto.resource = this.bundleRevision.dtoId;
            nodes.put(this, dto);
            for (BundleWire bw : this.getProvidedWires(null)) {
                BundleWireDTO bwdto = ((BundleWireImpl)bw).getDTO();
                dto.providedWires.add(bwdto);
                ((BundleRevisionImpl)bw.getRequirer()).getWiringImpl().walkWires(nodes, bwdto);
            }
            if (isRoot) {
                for (BundleWire bw : this.getRequiredWires(null)) {
                    ((BundleRevisionImpl)bw.getProvider()).getWiringImpl().walkWires(nodes, null);
                }
            }
        }
        if (wireDTO != null) {
            dto.requiredWires.add(wireDTO);
        }
    }
}

