/*
 * Decompiled with CFR 0.152.
 */
package ghidra.bitpatterns.info;

import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.support.GTreeFilter;
import ghidra.bitpatterns.info.FunctionBitPatternsGTreeNode;

public class PercentageFilter
implements GTreeFilter {
    private double percentage;

    public PercentageFilter(double percentage) {
        if (percentage < 0.0 || percentage > 100.0) {
            throw new IllegalArgumentException("Not a valid percentage: " + percentage);
        }
        this.percentage = percentage;
    }

    public boolean allows(double percentageToTest) {
        return percentageToTest >= this.percentage;
    }

    public String toString() {
        return "Percentage: " + Double.toString(this.percentage);
    }

    public boolean acceptsNode(GTreeNode node) {
        if (!(node instanceof FunctionBitPatternsGTreeNode)) {
            return false;
        }
        FunctionBitPatternsGTreeNode fbpgNode = (FunctionBitPatternsGTreeNode)node;
        return fbpgNode.getPercentage() >= this.percentage;
    }

    public boolean showFilterMatches() {
        return true;
    }
}

