/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis.validator;

import docking.widgets.conditiontestpanel.ConditionResult;
import docking.widgets.conditiontestpanel.ConditionStatus;
import ghidra.app.plugin.core.analysis.validator.PostAnalysisValidator;
import ghidra.app.util.PseudoDisassembler;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressIterator;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.util.task.TaskMonitor;

public class OffcutReferencesValidator
extends PostAnalysisValidator {
    private static final String NAME = "Offcut References Validator";
    private static final int MAX_OFFCUTS_TO_REPORT = 100;

    public OffcutReferencesValidator(Program program) {
        super(program);
    }

    @Override
    public ConditionResult doRun(TaskMonitor monitor) {
        StringBuilder warnings = new StringBuilder();
        if (PseudoDisassembler.hasLowBitCodeModeInAddrValues((Program)this.program)) {
            return new ConditionResult(ConditionStatus.Skipped, "Language supports offcut references to function entry points");
        }
        int references = this.checkOffcutReferences(this.program, warnings, monitor);
        return new ConditionResult(references > 0 ? ConditionStatus.Warning : ConditionStatus.Passed, warnings.toString());
    }

    private int checkOffcutReferences(Program prog, StringBuilder messages, TaskMonitor monitor) {
        Listing listing = prog.getListing();
        AddressSetView executeSet = prog.getMemory().getExecuteSet();
        ReferenceManager refManager = prog.getReferenceManager();
        AddressIterator refIter = refManager.getReferenceDestinationIterator(executeSet, true);
        int offcutRefCount = 0;
        monitor.setIndeterminate(true);
        while (refIter.hasNext() && !monitor.isCancelled()) {
            Address instAddr;
            Instruction instruction;
            monitor.incrementProgress(1L);
            Address toAddr = refIter.next();
            if (!toAddr.isMemoryAddress() || (instruction = listing.getInstructionContaining(toAddr)) == null || toAddr.equals((Object)(instAddr = instruction.getAddress()))) continue;
            if (++offcutRefCount < 100) {
                messages.append("&nbsp;&nbsp;&nbsp;&nbsp;" + String.valueOf(toAddr) + "\n");
                continue;
            }
            if (offcutRefCount != 100) continue;
            messages.append("&nbsp;&nbsp;&nbsp;&nbsp;[Too many offcut references to list...]\n");
        }
        if (offcutRefCount > 0) {
            messages.insert(0, prog.getDomainFile().getName() + " has " + offcutRefCount + " offcut code reference(s):\n");
        }
        return offcutRefCount;
    }

    public String getDescription() {
        return "Search for any offcut code references in the program";
    }

    public String getName() {
        return NAME;
    }

    public String toString() {
        return this.getName();
    }
}

