/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.lower;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.ir.backend.js.JsIrBackendContext;
import org.jetbrains.kotlin.ir.backend.js.JsStatementOrigins;
import org.jetbrains.kotlin.ir.backend.js.ir.JsIrBuilder;
import org.jetbrains.kotlin.ir.backend.js.lower.ClassReferenceLowering;
import org.jetbrains.kotlin.ir.backend.js.lower.JsClassReferenceLowering;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.symbols.IrClassSymbol;
import org.jetbrains.kotlin.ir.symbols.IrSimpleFunctionSymbol;
import org.jetbrains.kotlin.ir.types.IrType;
import org.jetbrains.kotlin.ir.types.IrTypePredicatesKt;
import org.jetbrains.kotlin.ir.types.IrTypesKt;
import org.jetbrains.kotlin.ir.util.IrTypeUtilsKt;
import org.jetbrains.kotlin.js.config.JSConfigurationKeysKt;
import org.jetbrains.kotlin.name.Name;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0018\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u00132\u0006\u0010*\u001a\u00020\u001dH\u0002J\u001a\u0010+\u001a\u0004\u0018\u00010(2\u0006\u0010*\u001a\u00020\u001d2\u0006\u0010,\u001a\u00020\u001dH\u0014J\u001a\u0010-\u001a\u0004\u0018\u00010(2\u0006\u0010*\u001a\u00020\u001d2\u0006\u0010,\u001a\u00020\u001dH\u0014J\u0018\u0010.\u001a\u00020(2\u0006\u0010*\u001a\u00020\u001d2\u0006\u0010,\u001a\u00020\u001dH\u0016J\u0010\u0010/\u001a\u00020(2\u0006\u00100\u001a\u00020\u001dH\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0010\u0010\u0011\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0012\u001a\u00020\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0011\u001a\u0004\b\u0014\u0010\u0015R3\u0010\u001a\u001a\u001a\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0\u001c\u0012\u0004\u0012\u00020\u00130\u001b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\u0011\u001a\u0004\b\u001f\u0010 R8\u0010\"\u001a\u001f\u0012\u0015\u0012\u0013\u0012\u0004\u0012\u00020\u001d\u0012\u0004\u0012\u00020\u001e0#\u00a2\u0006\u0002\b$\u0012\u0004\u0012\u00020\u00130\u001b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b&\u0010\u0011\u001a\u0004\b%\u0010 \u00a8\u00061"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/lower/JsClassReferenceLowering;", "Lorg/jetbrains/kotlin/ir/backend/js/lower/ClassReferenceLowering;", "context", "Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;", "<init>", "(Lorg/jetbrains/kotlin/ir/backend/js/JsIrBackendContext;)V", "getClassData", "Lorg/jetbrains/kotlin/ir/symbols/IrSimpleFunctionSymbol;", "primitiveClassesObject", "Lorg/jetbrains/kotlin/ir/symbols/IrClassSymbol;", "longArrayClassSymbol", "primitiveClassProperties", "", "Lorg/jetbrains/kotlin/ir/declarations/IrProperty;", "getPrimitiveClassProperties", "()Ljava/util/List;", "primitiveClassProperties$delegate", "Lkotlin/Lazy;", "primitiveClassFunctionClass", "Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "getPrimitiveClassFunctionClass", "()Lorg/jetbrains/kotlin/ir/declarations/IrSimpleFunction;", "primitiveClassFunctionClass$delegate", "primitiveClassProperty", "name", "", "finalPrimitiveClasses", "", "Lkotlin/Function1;", "Lorg/jetbrains/kotlin/ir/types/IrType;", "", "getFinalPrimitiveClasses", "()Ljava/util/Map;", "finalPrimitiveClasses$delegate", "openPrimitiveClasses", "Lkotlin/reflect/KFunction1;", "Lkotlin/ExtensionFunctionType;", "getOpenPrimitiveClasses", "openPrimitiveClasses$delegate", "getPrimitiveClass", "Lorg/jetbrains/kotlin/ir/expressions/IrCall;", "target", "returnType", "getFinalPrimitiveKClass", "typeArgument", "getOpenPrimitiveKClass", "callGetKClass", "callGetClassByType", "type", "backend.js"})
@SourceDebugExtension(value={"SMAP\nClassReferenceLowering.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassReferenceLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/JsClassReferenceLowering\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 MemoryOptimizedCollectionUtil.kt\norg/jetbrains/kotlin/utils/MemoryOptimizedCollectionUtilKt\n+ 4 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,290:1\n672#2,11:291\n812#2,12:302\n629#2,12:314\n812#2,12:326\n1266#2,4:346\n1266#2,4:352\n135#3,6:338\n466#4:344\n415#4:345\n466#4:350\n415#4:351\n*S KotlinDebug\n*F\n+ 1 ClassReferenceLowering.kt\norg/jetbrains/kotlin/ir/backend/js/lower/JsClassReferenceLowering\n*L\n44#1:291,11\n46#1:302,12\n47#1:314,12\n35#1:326,12\n67#1:346,4\n78#1:352,4\n40#1:338,6\n67#1:344\n67#1:345\n78#1:350\n78#1:351\n*E\n"})
public final class JsClassReferenceLowering
extends ClassReferenceLowering {
    @NotNull
    private final IrSimpleFunctionSymbol getClassData;
    @NotNull
    private final IrClassSymbol primitiveClassesObject;
    @NotNull
    private final IrSimpleFunctionSymbol longArrayClassSymbol;
    @NotNull
    private final Lazy primitiveClassProperties$delegate;
    @NotNull
    private final Lazy primitiveClassFunctionClass$delegate;
    @NotNull
    private final Lazy finalPrimitiveClasses$delegate;
    @NotNull
    private final Lazy openPrimitiveClasses$delegate;

    public JsClassReferenceLowering(@NotNull JsIrBackendContext context2) {
        Intrinsics.checkNotNullParameter(context2, "context");
        super(context2);
        this.getClassData = context2.getIntrinsics().getJsClass();
        this.primitiveClassesObject = context2.getIntrinsics().getPrimitiveClassesObject();
        this.longArrayClassSymbol = context2.getIntrinsics().getLongArrayClass();
        this.primitiveClassProperties$delegate = LazyKt.lazy(LazyThreadSafetyMode.NONE, () -> JsClassReferenceLowering.primitiveClassProperties_delegate$lambda$0(this));
        this.primitiveClassFunctionClass$delegate = LazyKt.lazy(LazyThreadSafetyMode.NONE, () -> JsClassReferenceLowering.primitiveClassFunctionClass_delegate$lambda$0(this));
        this.finalPrimitiveClasses$delegate = LazyKt.lazy(LazyThreadSafetyMode.NONE, () -> JsClassReferenceLowering.finalPrimitiveClasses_delegate$lambda$0(context2, this));
        this.openPrimitiveClasses$delegate = LazyKt.lazy(LazyThreadSafetyMode.NONE, () -> JsClassReferenceLowering.openPrimitiveClasses_delegate$lambda$0(this));
    }

    private final List<IrProperty> getPrimitiveClassProperties() {
        Lazy lazy = this.primitiveClassProperties$delegate;
        return (List)lazy.getValue();
    }

    private final IrSimpleFunction getPrimitiveClassFunctionClass() {
        Lazy lazy = this.primitiveClassFunctionClass$delegate;
        return (IrSimpleFunction)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    private final IrSimpleFunction primitiveClassProperty(String name2) {
        IrDeclarationBase irDeclarationBase;
        Object v0;
        block7: {
            Iterable $this$singleOrNull$iv = this.getPrimitiveClassProperties();
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                IrProperty it = (IrProperty)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getName(), Name.identifier(name2))) continue;
                if (found$iv) {
                    v0 = null;
                    break block7;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v0 = !found$iv ? null : single$iv;
        }
        if ((irDeclarationBase = (IrProperty)v0) == null || (irDeclarationBase = irDeclarationBase.getGetter()) == null) {
            void $this$filterIsInstanceTo$iv$iv;
            Iterable $this$filterIsInstance$iv = ((IrClass)this.primitiveClassesObject.getOwner()).getDeclarations();
            boolean $i$f$filterIsInstance = false;
            Iterable found$iv = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof IrSimpleFunction)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$single$iv = (List)destination$iv$iv;
            boolean $i$f$single = false;
            Object single$iv = null;
            boolean found$iv2 = false;
            for (Object element$iv : $this$single$iv) {
                IrSimpleFunction it = (IrSimpleFunction)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getName(), Name.special("<get-" + name2 + '>'))) continue;
                if (found$iv2) {
                    throw new IllegalArgumentException("Collection contains more than one matching element.");
                }
                single$iv = element$iv;
                found$iv2 = true;
            }
            if (!found$iv2) {
                throw new NoSuchElementException("Collection contains no element matching the predicate.");
            }
            irDeclarationBase = single$iv;
        }
        return irDeclarationBase;
    }

    private final Map<Function1<IrType, Boolean>, IrSimpleFunction> getFinalPrimitiveClasses() {
        Lazy lazy = this.finalPrimitiveClasses$delegate;
        return (Map)lazy.getValue();
    }

    private final Map<KFunction<Boolean>, IrSimpleFunction> getOpenPrimitiveClasses() {
        Lazy lazy = this.openPrimitiveClasses$delegate;
        return (Map)lazy.getValue();
    }

    private final IrCall getPrimitiveClass(IrSimpleFunction target, IrType returnType) {
        IrCall irCall;
        IrCall $this$getPrimitiveClass_u24lambda_u240 = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, target.getSymbol(), returnType, null, null, null, 0, 0, 124, null);
        boolean bl = false;
        $this$getPrimitiveClass_u24lambda_u240.getArguments().set(0, JsIrBuilder.INSTANCE.buildGetObjectValue(IrTypesKt.getDefaultType(this.primitiveClassesObject), this.primitiveClassesObject));
        return irCall;
    }

    @Override
    @Nullable
    protected IrCall getFinalPrimitiveKClass(@NotNull IrType returnType, @NotNull IrType typeArgument) {
        Intrinsics.checkNotNullParameter(returnType, "returnType");
        Intrinsics.checkNotNullParameter(typeArgument, "typeArgument");
        if (IrTypePredicatesKt.isLongArray(typeArgument)) {
            return JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.longArrayClassSymbol, returnType, null, null, null, 0, 0, 124, null);
        }
        for (Map.Entry<Function1<IrType, Boolean>, IrSimpleFunction> entry : this.getFinalPrimitiveClasses().entrySet()) {
            Function1<IrType, Boolean> typePredicate = entry.getKey();
            IrSimpleFunction v2 = entry.getValue();
            if (!typePredicate.invoke(typeArgument).booleanValue()) continue;
            return this.getPrimitiveClass(v2, returnType);
        }
        return null;
    }

    @Override
    @Nullable
    protected IrCall getOpenPrimitiveKClass(@NotNull IrType returnType, @NotNull IrType typeArgument) {
        Intrinsics.checkNotNullParameter(returnType, "returnType");
        Intrinsics.checkNotNullParameter(typeArgument, "typeArgument");
        for (Map.Entry<KFunction<Boolean>, IrSimpleFunction> entry : this.getOpenPrimitiveClasses().entrySet()) {
            KFunction<Boolean> typePredicate = entry.getKey();
            IrSimpleFunction v2 = entry.getValue();
            if (!((Boolean)((Function1)((Object)typePredicate)).invoke(typeArgument)).booleanValue()) continue;
            return this.getPrimitiveClass(v2, returnType);
        }
        if (IrTypeUtilsKt.isFunction(typeArgument)) {
            IrCall irCall;
            IrClass irClass = IrTypesKt.getClass(typeArgument);
            Intrinsics.checkNotNull(irClass);
            IrClass functionInterface = irClass;
            int arity = functionInterface.getTypeParameters().size() - 1;
            IrCall $this$getOpenPrimitiveKClass_u24lambda_u240 = irCall = this.getPrimitiveClass(this.getPrimitiveClassFunctionClass(), returnType);
            boolean bl = false;
            $this$getOpenPrimitiveKClass_u24lambda_u240.getArguments().set(1, JsIrBuilder.INSTANCE.buildInt(this.getContext().getIrBuiltIns().getIntType(), arity));
            return irCall;
        }
        return null;
    }

    @Override
    @NotNull
    public IrCall callGetKClass(@NotNull IrType returnType, @NotNull IrType typeArgument) {
        IrCall irCall;
        IrCall primitiveKClass;
        Intrinsics.checkNotNullParameter(returnType, "returnType");
        Intrinsics.checkNotNullParameter(typeArgument, "typeArgument");
        IrCall irCall2 = this.getFinalPrimitiveKClass(returnType, typeArgument);
        if (irCall2 == null) {
            irCall2 = this.getOpenPrimitiveKClass(returnType, typeArgument);
        }
        if ((primitiveKClass = irCall2) != null) {
            return primitiveKClass;
        }
        IrCall $this$callGetKClass_u24lambda_u240 = irCall = JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.getReflectionSymbols().getGetKClass(), returnType, CollectionsKt.listOf(typeArgument), null, null, 0, 0, 120, null);
        boolean bl = false;
        $this$callGetKClass_u24lambda_u240.getArguments().set(0, this.callGetClassByType(typeArgument));
        return irCall;
    }

    private final IrCall callGetClassByType(IrType type) {
        return JsIrBuilder.buildCall$default(JsIrBuilder.INSTANCE, this.getClassData, null, CollectionsKt.listOf(type), JsStatementOrigins.INSTANCE.getCLASS_REFERENCE(), null, 0, 0, 114, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final List primitiveClassProperties_delegate$lambda$0(JsClassReferenceLowering this$0) {
        void $this$filterIsInstanceTo$iv$iv;
        Iterable $this$filterIsInstance$iv = ((IrClass)this$0.primitiveClassesObject.getOwner()).getDeclarations();
        boolean $i$f$filterIsInstance = false;
        Iterable iterable = $this$filterIsInstance$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIsInstanceTo = false;
        for (Object element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
            if (!(element$iv$iv instanceof IrProperty)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private static final IrSimpleFunction primitiveClassFunctionClass_delegate$lambda$0(JsClassReferenceLowering this$0) {
        Object v0;
        block1: {
            Iterable $this$findIsInstanceAnd$iv = ((IrClass)this$0.primitiveClassesObject.getOwner()).getDeclarations();
            boolean $i$f$findIsInstanceAnd = false;
            for (Object element$iv : $this$findIsInstanceAnd$iv) {
                if (!(element$iv instanceof IrSimpleFunction)) continue;
                IrSimpleFunction it = (IrSimpleFunction)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual(it.getName(), Name.identifier("functionClass"))) continue;
                v0 = element$iv;
                break block1;
            }
            v0 = null;
        }
        Intrinsics.checkNotNull(v0);
        return v0;
    }

    private static final boolean finalPrimitiveClasses_delegate$lambda$0$0(JsIrBackendContext $context, IrType type) {
        Intrinsics.checkNotNullParameter(type, "type");
        return IrTypePredicatesKt.isLong(type) && JSConfigurationKeysKt.getCompileLongAsBigint($context.getConfiguration());
    }

    /*
     * WARNING - void declaration
     */
    private static final Map finalPrimitiveClasses_delegate$lambda$0(JsIrBackendContext $context, JsClassReferenceLowering this$0) {
        void $this$associateByTo$iv$iv$iv;
        void $this$mapValuesTo$iv$iv;
        Pair[] pairArray = new Pair[]{TuplesKt.to(finalPrimitiveClasses.2.1.INSTANCE, "booleanClass"), TuplesKt.to(finalPrimitiveClasses.2.2.INSTANCE, "byteClass"), TuplesKt.to(finalPrimitiveClasses.2.3.INSTANCE, "shortClass"), TuplesKt.to(finalPrimitiveClasses.2.4.INSTANCE, "intClass"), TuplesKt.to(finalPrimitiveClasses.2.5.INSTANCE, "floatClass"), TuplesKt.to(finalPrimitiveClasses.2.6.INSTANCE, "doubleClass"), TuplesKt.to(arg_0 -> JsClassReferenceLowering.finalPrimitiveClasses_delegate$lambda$0$0($context, arg_0), "longClass"), TuplesKt.to(finalPrimitiveClasses.2.8.INSTANCE, "arrayClass"), TuplesKt.to(finalPrimitiveClasses.2.9.INSTANCE, "stringClass"), TuplesKt.to(finalPrimitiveClasses.2.10.INSTANCE, "booleanArrayClass"), TuplesKt.to(finalPrimitiveClasses.2.11.INSTANCE, "charArrayClass"), TuplesKt.to(finalPrimitiveClasses.2.12.INSTANCE, "byteArrayClass"), TuplesKt.to(finalPrimitiveClasses.2.13.INSTANCE, "shortArrayClass"), TuplesKt.to(finalPrimitiveClasses.2.14.INSTANCE, "intArrayClass"), TuplesKt.to(finalPrimitiveClasses.2.15.INSTANCE, "floatArrayClass"), TuplesKt.to(finalPrimitiveClasses.2.16.INSTANCE, "doubleArrayClass")};
        Map $this$mapValues$iv = MapsKt.mapOf(pairArray);
        boolean $i$f$mapValues = false;
        Map map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity($this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable iterable = $this$mapValuesTo$iv$iv.entrySet();
        Map destination$iv$iv$iv = destination$iv$iv;
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k2 = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            IrSimpleFunction irSimpleFunction = this$0.primitiveClassProperty((String)it.getValue());
            map3.put(k2, irSimpleFunction);
        }
        return destination$iv$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private static final Map openPrimitiveClasses_delegate$lambda$0(JsClassReferenceLowering this$0) {
        void $this$associateByTo$iv$iv$iv;
        void $this$mapValuesTo$iv$iv;
        Pair[] pairArray = new Pair[]{TuplesKt.to(openPrimitiveClasses.2.1.INSTANCE, "anyClass"), TuplesKt.to(openPrimitiveClasses.2.2.INSTANCE, "numberClass"), TuplesKt.to(openPrimitiveClasses.2.3.INSTANCE, "throwableClass"), TuplesKt.to(openPrimitiveClasses.2.4.INSTANCE, "nothingClass")};
        Map $this$mapValues$iv = MapsKt.mapOf(pairArray);
        boolean $i$f$mapValues = false;
        Map map = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity($this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable iterable = $this$mapValuesTo$iv$iv.entrySet();
        Map destination$iv$iv$iv = destination$iv$iv;
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it;
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map2 = destination$iv$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k2 = it$iv$iv.getKey();
            Map map3 = map2;
            boolean bl2 = false;
            IrSimpleFunction irSimpleFunction = this$0.primitiveClassProperty((String)it.getValue());
            map3.put(k2, irSimpleFunction);
        }
        return destination$iv$iv$iv;
    }
}

