/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.scripting.definitions;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.sequences.Sequence;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010(\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001\u000eB\u0015\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\tH\u0096\u0082\u0004R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u0012\u0012\u0004\u0012\u00028\u00000\u000bj\b\u0012\u0004\u0012\u00028\u0000`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/scripting/definitions/CachingSequence;", "T", "Lkotlin/sequences/Sequence;", "from", "<init>", "(Lkotlin/sequences/Sequence;)V", "lock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "sequenceIterator", "", "cache", "Ljava/util/ArrayList;", "Lkotlin/collections/ArrayList;", "iterator", "CachingIterator", "kotlin-scripting-compiler-impl"})
final class CachingSequence<T>
implements Sequence<T> {
    @NotNull
    private final ReentrantReadWriteLock lock;
    @NotNull
    private final Iterator<T> sequenceIterator;
    @NotNull
    private final ArrayList<T> cache;

    public CachingSequence(@NotNull Sequence<? extends T> from) {
        Intrinsics.checkNotNullParameter(from, (String)"from");
        this.lock = new ReentrantReadWriteLock();
        this.sequenceIterator = from.iterator();
        this.cache = new ArrayList();
    }

    @NotNull
    public Iterator<T> iterator() {
        return new CachingIterator();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00028\u00000\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\n\u0010\u0006\u001a\u00020\u0007H\u0096\u0082\u0004J\u000f\u0010\b\u001a\u00028\u0000H\u0096\u0082\u0004\u00a2\u0006\u0002\u0010\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/kotlin/scripting/definitions/CachingSequence$CachingIterator;", "", "<init>", "(Lorg/jetbrains/kotlin/scripting/definitions/CachingSequence;)V", "cacheCursor", "", "hasNext", "", "next", "()Ljava/lang/Object;", "kotlin-scripting-compiler-impl"})
    @SourceDebugExtension(value={"SMAP\nLazyScriptDefinitionProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LazyScriptDefinitionProvider.kt\norg/jetbrains/kotlin/scripting/definitions/CachingSequence$CachingIterator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,117:1\n1#2:118\n*E\n"})
    private final class CachingIterator
    implements Iterator<T>,
    KMappedMarker {
        private int cacheCursor;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean hasNext() {
            boolean bl;
            int n;
            ReentrantReadWriteLock reentrantReadWriteLock = CachingSequence.this.lock;
            CachingSequence cachingSequence = CachingSequence.this;
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            readLock.lock();
            try {
                boolean bl2 = false;
                n = this.cacheCursor < cachingSequence.cache.size() ? 1 : 0;
            }
            finally {
                readLock.unlock();
            }
            if (n != 0) return true;
            reentrantReadWriteLock = CachingSequence.this.lock;
            cachingSequence = CachingSequence.this;
            readLock = reentrantReadWriteLock.readLock();
            n = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            for (int i = 0; i < n; ++i) {
                readLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                boolean bl3 = false;
                bl = this.cacheCursor < cachingSequence.cache.size() || cachingSequence.sequenceIterator.hasNext();
            }
            finally {
                for (int i = 0; i < n; ++i) {
                    readLock.lock();
                }
                writeLock.unlock();
            }
            if (!bl) return false;
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T next() {
            int n;
            ReentrantReadWriteLock reentrantReadWriteLock = CachingSequence.this.lock;
            CachingSequence cachingSequence = CachingSequence.this;
            ReentrantReadWriteLock.ReadLock readLock = reentrantReadWriteLock.readLock();
            readLock.lock();
            try {
                boolean bl = false;
                if (this.cacheCursor < cachingSequence.cache.size()) {
                    int n2 = this.cacheCursor;
                    this.cacheCursor = n2 + 1;
                    Object e = cachingSequence.cache.get(n2);
                    return e;
                }
                Unit unit = Unit.INSTANCE;
            }
            finally {
                readLock.unlock();
            }
            reentrantReadWriteLock = CachingSequence.this.lock;
            cachingSequence = CachingSequence.this;
            readLock = reentrantReadWriteLock.readLock();
            int n3 = reentrantReadWriteLock.getWriteHoldCount() == 0 ? reentrantReadWriteLock.getReadHoldCount() : 0;
            for (int i = 0; i < n3; ++i) {
                readLock.unlock();
            }
            ReentrantReadWriteLock.WriteLock writeLock = reentrantReadWriteLock.writeLock();
            writeLock.lock();
            try {
                Object e;
                boolean bl = false;
                if (this.cacheCursor < cachingSequence.cache.size()) {
                    n = this.cacheCursor;
                    this.cacheCursor = n + 1;
                    e = cachingSequence.cache.get(n);
                } else {
                    Object e2;
                    Object it = e2 = cachingSequence.sequenceIterator.next();
                    boolean bl2 = false;
                    cachingSequence.cache.add(it);
                    e = e2;
                }
                Object e3 = e;
                return e3;
            }
            finally {
                for (n = 0; n < n3; ++n) {
                    readLock.lock();
                }
                writeLock.unlock();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Operation is not supported for read-only collection");
        }
    }
}

