/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.router;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import net.osmand.PlatformUtil;
import net.osmand.binary.BinaryMapIndexReader;
import net.osmand.binary.RouteDataObject;
import net.osmand.data.LatLon;
import net.osmand.data.QuadPoint;
import net.osmand.router.BinaryRoutePlanner;
import net.osmand.router.PrecalculatedRouteDirection;
import net.osmand.router.RouteCalculationProgress;
import net.osmand.router.RouteResultPreparation;
import net.osmand.router.RouteSegmentResult;
import net.osmand.router.RoutingConfiguration;
import net.osmand.router.RoutingContext;
import net.osmand.util.MapUtils;
import org.apache.commons.logging.Log;

public class RoutePlannerFrontEnd {
    private boolean useOldVersion;
    protected static final Log log = PlatformUtil.getLog(RoutePlannerFrontEnd.class);
    public boolean useSmartRouteRecalculation = true;

    public RoutePlannerFrontEnd(boolean useOldVersion) {
        this.useOldVersion = useOldVersion;
    }

    public RoutingContext buildRoutingContext(RoutingConfiguration config, BinaryMapIndexReader[] map, RouteCalculationMode rm) {
        return new RoutingContext(config, map, rm);
    }

    public RoutingContext buildRoutingContext(RoutingConfiguration config, BinaryMapIndexReader[] map) {
        return new RoutingContext(config, map, RouteCalculationMode.NORMAL);
    }

    private static double squareDist(int x1, int y1, int x2, int y2) {
        double dy = MapUtils.convert31YToMeters(y1, y2);
        double dx = MapUtils.convert31XToMeters(x1, x2);
        return dx * dx + dy * dy;
    }

    public BinaryRoutePlanner.RouteSegmentPoint findRouteSegment(double lat, double lon, RoutingContext ctx, List<BinaryRoutePlanner.RouteSegmentPoint> list) throws IOException {
        int px = MapUtils.get31TileNumberX(lon);
        int py = MapUtils.get31TileNumberY(lat);
        ArrayList<RouteDataObject> dataObjects = new ArrayList<RouteDataObject>();
        ctx.loadTileData(px, py, 17, dataObjects);
        if (dataObjects.isEmpty()) {
            ctx.loadTileData(px, py, 15, dataObjects);
        }
        if (list == null) {
            list = new ArrayList<BinaryRoutePlanner.RouteSegmentPoint>();
        }
        for (RouteDataObject r : dataObjects) {
            if (r.getPointsLength() <= 1) continue;
            BinaryRoutePlanner.RouteSegmentPoint road = null;
            for (int j = 1; j < r.getPointsLength(); ++j) {
                QuadPoint pr = MapUtils.getProjectionPoint31(px, py, r.getPoint31XTile(j - 1), r.getPoint31YTile(j - 1), r.getPoint31XTile(j), r.getPoint31YTile(j));
                double currentsDistSquare = RoutePlannerFrontEnd.squareDist((int)pr.x, (int)pr.y, px, py);
                if (road != null && !(currentsDistSquare < road.distSquare)) continue;
                RouteDataObject ro = new RouteDataObject(r);
                road = new BinaryRoutePlanner.RouteSegmentPoint(ro, j, currentsDistSquare);
                road.preciseX = (int)pr.x;
                road.preciseY = (int)pr.y;
            }
            if (road == null) continue;
            list.add(road);
        }
        Collections.sort(list, new Comparator<BinaryRoutePlanner.RouteSegmentPoint>(){

            @Override
            public int compare(BinaryRoutePlanner.RouteSegmentPoint o1, BinaryRoutePlanner.RouteSegmentPoint o2) {
                return Double.compare(o1.distSquare, o2.distSquare);
            }
        });
        if (list.size() > 0) {
            BinaryRoutePlanner.RouteSegmentPoint ps = list.get(0);
            ps.others = list;
            return ps;
        }
        return null;
    }

    public List<RouteSegmentResult> searchRoute(RoutingContext ctx, LatLon start, LatLon end, List<LatLon> intermediates) throws IOException, InterruptedException {
        return this.searchRoute(ctx, start, end, intermediates, null);
    }

    public void setUseFastRecalculation(boolean use) {
        this.useSmartRouteRecalculation = use;
    }

    public List<RouteSegmentResult> searchRoute(RoutingContext ctx, LatLon start, LatLon end, List<LatLon> intermediates, PrecalculatedRouteDirection routeDirection) throws IOException, InterruptedException {
        if (ctx.calculationProgress == null) {
            ctx.calculationProgress = new RouteCalculationProgress();
        }
        boolean intermediatesEmpty = intermediates == null || intermediates.isEmpty();
        double maxDistance = MapUtils.getDistance(start, end);
        if (!intermediatesEmpty) {
            LatLon b = start;
            for (LatLon latLon : intermediates) {
                maxDistance = Math.max(MapUtils.getDistance(b, latLon), maxDistance);
                b = latLon;
            }
        }
        if (ctx.calculationMode == RouteCalculationMode.COMPLEX && routeDirection == null && maxDistance > (double)(ctx.config.DEVIATION_RADIUS * 6.0f)) {
            RoutingContext nctx = this.buildRoutingContext(ctx.config, ctx.getMaps(), RouteCalculationMode.BASE);
            nctx.calculationProgress = ctx.calculationProgress;
            List<RouteSegmentResult> ls = this.searchRoute(nctx, start, end, intermediates);
            routeDirection = PrecalculatedRouteDirection.build(ls, ctx.config.DEVIATION_RADIUS, ctx.getRouter().getMaxDefaultSpeed());
        }
        int indexNotFound = 0;
        ArrayList<BinaryRoutePlanner.RouteSegmentPoint> points = new ArrayList<BinaryRoutePlanner.RouteSegmentPoint>();
        if (!this.addSegment(start, ctx, indexNotFound++, points)) {
            return null;
        }
        if (intermediates != null) {
            for (LatLon l : intermediates) {
                if (this.addSegment(l, ctx, indexNotFound++, points)) continue;
                return null;
            }
        }
        if (!this.addSegment(end, ctx, indexNotFound++, points)) {
            return null;
        }
        List<RouteSegmentResult> list = this.searchRoute(ctx, points, routeDirection);
        this.makeStartEndPointsPrecise(list, start, end, intermediates);
        if (list != null) {
            new RouteResultPreparation().printResults(ctx, start, end, list);
        }
        return list;
    }

    protected void makeStartEndPointsPrecise(List<RouteSegmentResult> res, LatLon start, LatLon end, List<LatLon> intermediates) {
        if (res.size() > 0) {
            this.updateResult(res.get(0), start, true);
            this.updateResult(res.get(res.size() - 1), end, false);
            if (intermediates != null) {
                int k = 1;
                block0: for (int i = 0; i < intermediates.size(); ++i) {
                    LatLon ll = intermediates.get(i);
                    int px = MapUtils.get31TileNumberX(ll.getLongitude());
                    int py = MapUtils.get31TileNumberY(ll.getLatitude());
                    while (k < res.size()) {
                        double currentsDist = this.projectDistance(res, k, px, py);
                        if (currentsDist < 250000.0) {
                            for (int k1 = k + 1; k1 < res.size(); ++k1) {
                                double c2 = this.projectDistance(res, k1, px, py);
                                if (c2 < currentsDist) {
                                    k = k1;
                                    currentsDist = c2;
                                    continue;
                                }
                                if (k1 - k > 15) break;
                            }
                            this.updateResult(res.get(k), ll, false);
                            if (k >= res.size() - 1) continue block0;
                            this.updateResult(res.get(k + 1), ll, true);
                            continue block0;
                        }
                        ++k;
                    }
                }
            }
        }
    }

    protected double projectDistance(List<RouteSegmentResult> res, int k, int px, int py) {
        RouteSegmentResult sr = res.get(k);
        RouteDataObject r = sr.getObject();
        QuadPoint pp = MapUtils.getProjectionPoint31(px, py, r.getPoint31XTile(sr.getStartPointIndex()), r.getPoint31YTile(sr.getStartPointIndex()), r.getPoint31XTile(sr.getEndPointIndex()), r.getPoint31YTile(sr.getEndPointIndex()));
        double currentsDist = RoutePlannerFrontEnd.squareDist((int)pp.x, (int)pp.y, px, py);
        return currentsDist;
    }

    private void updateResult(RouteSegmentResult routeSegmentResult, LatLon point, boolean st) {
        int px = MapUtils.get31TileNumberX(point.getLongitude());
        int py = MapUtils.get31TileNumberY(point.getLatitude());
        int pind = st ? routeSegmentResult.getStartPointIndex() : routeSegmentResult.getEndPointIndex();
        RouteDataObject r = routeSegmentResult.getObject();
        QuadPoint before = null;
        QuadPoint after = null;
        if (pind > 0) {
            before = MapUtils.getProjectionPoint31(px, py, r.getPoint31XTile(pind - 1), r.getPoint31YTile(pind - 1), r.getPoint31XTile(pind), r.getPoint31YTile(pind));
        }
        if (pind < r.getPointsLength() - 1) {
            after = MapUtils.getProjectionPoint31(px, py, r.getPoint31XTile(pind + 1), r.getPoint31YTile(pind + 1), r.getPoint31XTile(pind), r.getPoint31YTile(pind));
        }
        int insert = 0;
        double dd = MapUtils.getDistance(point, MapUtils.get31LatitudeY(r.getPoint31YTile(pind)), MapUtils.get31LongitudeX(r.getPoint31XTile(pind)));
        double ddBefore = Double.POSITIVE_INFINITY;
        double ddAfter = Double.POSITIVE_INFINITY;
        QuadPoint i = null;
        if (before != null && (ddBefore = MapUtils.getDistance(point, MapUtils.get31LatitudeY((int)before.y), MapUtils.get31LongitudeX((int)before.x))) < dd) {
            insert = -1;
            i = before;
        }
        if (after != null && (ddAfter = MapUtils.getDistance(point, MapUtils.get31LatitudeY((int)after.y), MapUtils.get31LongitudeX((int)after.x))) < dd && ddAfter < ddBefore) {
            insert = 1;
            i = after;
        }
        if (insert != 0) {
            if (st && routeSegmentResult.getStartPointIndex() < routeSegmentResult.getEndPointIndex()) {
                routeSegmentResult.setEndPointIndex(routeSegmentResult.getEndPointIndex() + 1);
            }
            if (!st && routeSegmentResult.getStartPointIndex() > routeSegmentResult.getEndPointIndex()) {
                routeSegmentResult.setStartPointIndex(routeSegmentResult.getStartPointIndex() + 1);
            }
            if (insert > 0) {
                r.insert(pind + 1, (int)i.x, (int)i.y);
                if (st) {
                    routeSegmentResult.setStartPointIndex(routeSegmentResult.getStartPointIndex() + 1);
                }
                if (!st) {
                    routeSegmentResult.setEndPointIndex(routeSegmentResult.getEndPointIndex() + 1);
                }
            } else {
                r.insert(pind, (int)i.x, (int)i.y);
            }
        }
    }

    private boolean addSegment(LatLon s, RoutingContext ctx, int indexNotFound, List<BinaryRoutePlanner.RouteSegmentPoint> res) throws IOException {
        BinaryRoutePlanner.RouteSegmentPoint f = this.findRouteSegment(s.getLatitude(), s.getLongitude(), ctx, null);
        if (f == null) {
            ctx.calculationProgress.segmentNotFound = indexNotFound;
            return false;
        }
        log.info((Object)("Route segment found " + f.getRoad().id + " " + f.getRoad().getName()));
        res.add(f);
        return true;
    }

    private List<RouteSegmentResult> searchRouteInternalPrepare(RoutingContext ctx, BinaryRoutePlanner.RouteSegmentPoint start, BinaryRoutePlanner.RouteSegmentPoint end, PrecalculatedRouteDirection routeDirection) throws IOException, InterruptedException {
        BinaryRoutePlanner.RouteSegment recalculationEnd = this.getRecalculationEnd(ctx);
        if (recalculationEnd != null) {
            ctx.initStartAndTargetPoints(start, recalculationEnd);
        } else {
            ctx.initStartAndTargetPoints(start, end);
        }
        if (routeDirection != null) {
            ctx.precalculatedRouteDirection = routeDirection.adopt(ctx);
        }
        this.refreshProgressDistance(ctx);
        ctx.finalRouteSegment = new BinaryRoutePlanner().searchRouteInternal(ctx, start, end, recalculationEnd);
        return new RouteResultPreparation().prepareResult(ctx, ctx.finalRouteSegment);
    }

    public BinaryRoutePlanner.RouteSegment getRecalculationEnd(RoutingContext ctx) {
        boolean runRecalculation;
        BinaryRoutePlanner.RouteSegment recalculationEnd = null;
        boolean bl = runRecalculation = ctx.previouslyCalculatedRoute != null && ctx.previouslyCalculatedRoute.size() > 0 && ctx.config.recalculateDistance != 0.0f;
        if (runRecalculation) {
            ArrayList<RouteSegmentResult> rlist = new ArrayList<RouteSegmentResult>();
            float distanceThreshold = ctx.config.recalculateDistance;
            float threshold = 0.0f;
            for (RouteSegmentResult rr : ctx.previouslyCalculatedRoute) {
                if (!((threshold += rr.getDistance()) > distanceThreshold)) continue;
                rlist.add(rr);
            }
            boolean bl2 = runRecalculation = rlist.size() > 0;
            if (rlist.size() > 0) {
                BinaryRoutePlanner.RouteSegment previous = null;
                for (int i = 0; i <= rlist.size() - 1; ++i) {
                    RouteSegmentResult rr = (RouteSegmentResult)rlist.get(i);
                    BinaryRoutePlanner.RouteSegment segment = new BinaryRoutePlanner.RouteSegment(rr.getObject(), rr.getEndPointIndex());
                    if (previous != null) {
                        previous.setParentRoute(segment);
                        previous.setParentSegmentEnd(rr.getStartPointIndex());
                    } else {
                        recalculationEnd = segment;
                    }
                    previous = segment;
                }
            }
        }
        return recalculationEnd;
    }

    private void refreshProgressDistance(RoutingContext ctx) {
        if (ctx.calculationProgress != null) {
            ctx.calculationProgress.distanceFromBegin = 0.0f;
            ctx.calculationProgress.distanceFromEnd = 0.0f;
            ctx.calculationProgress.reverseSegmentQueueSize = 0;
            ctx.calculationProgress.directSegmentQueueSize = 0;
            float rd = (float)MapUtils.squareRootDist31(ctx.startX, ctx.startY, ctx.targetX, ctx.targetY);
            float speed = 0.9f * ctx.config.router.getMaxDefaultSpeed();
            ctx.calculationProgress.totalEstimatedDistance = rd / speed;
        }
    }

    private List<RouteSegmentResult> searchRoute(RoutingContext ctx, List<BinaryRoutePlanner.RouteSegmentPoint> points, PrecalculatedRouteDirection routeDirection) throws IOException, InterruptedException {
        if (points.size() <= 2) {
            if (!this.useSmartRouteRecalculation) {
                ctx.previouslyCalculatedRoute = null;
            }
            return this.searchRoute(ctx, points.get(0), points.get(1), routeDirection);
        }
        ArrayList<RouteSegmentResult> firstPartRecalculatedRoute = null;
        ArrayList<RouteSegmentResult> restPartRecalculatedRoute = null;
        if (ctx.previouslyCalculatedRoute != null) {
            List<RouteSegmentResult> prev = ctx.previouslyCalculatedRoute;
            long id2 = points.get((int)1).getRoad().id;
            short ss = points.get(1).getSegmentStart();
            int px = points.get(1).getRoad().getPoint31XTile(ss);
            int py = points.get(1).getRoad().getPoint31YTile(ss);
            for (int i = 0; i < prev.size(); ++i) {
                RouteSegmentResult rsr = prev.get(i);
                if (id2 != rsr.getObject().getId() || !(MapUtils.getDistance(rsr.getPoint(rsr.getEndPointIndex()), MapUtils.get31LatitudeY(py), MapUtils.get31LongitudeX(px)) < 50.0)) continue;
                firstPartRecalculatedRoute = new ArrayList<RouteSegmentResult>(i + 1);
                restPartRecalculatedRoute = new ArrayList<RouteSegmentResult>(prev.size() - i);
                for (int k = 0; k < prev.size(); ++k) {
                    if (k <= i) {
                        firstPartRecalculatedRoute.add(prev.get(k));
                        continue;
                    }
                    restPartRecalculatedRoute.add(prev.get(k));
                }
                System.out.println("Recalculate only first part of the route");
                break;
            }
        }
        ArrayList<RouteSegmentResult> results = new ArrayList<RouteSegmentResult>();
        for (int i = 0; i < points.size() - 1; ++i) {
            RoutingContext local = new RoutingContext(ctx);
            if (i == 0 && this.useSmartRouteRecalculation) {
                local.previouslyCalculatedRoute = firstPartRecalculatedRoute;
            }
            local.visitor = ctx.visitor;
            local.calculationProgress = ctx.calculationProgress;
            List<RouteSegmentResult> res = this.searchRouteInternalPrepare(local, points.get(i), points.get(i + 1), routeDirection);
            results.addAll(res);
            ctx.distinctLoadedTiles += local.distinctLoadedTiles;
            ctx.loadedTiles += local.loadedTiles;
            ctx.visitedSegments += local.visitedSegments;
            ctx.loadedPrevUnloadedTiles += local.loadedPrevUnloadedTiles;
            ctx.timeToCalculate += local.timeToCalculate;
            ctx.timeToLoad += local.timeToLoad;
            ctx.timeToLoadHeaders += local.timeToLoadHeaders;
            ctx.relaxedSegments += local.relaxedSegments;
            ctx.routingTime += local.routingTime;
            local.unloadAllData(ctx);
            if (restPartRecalculatedRoute == null) continue;
            results.addAll(restPartRecalculatedRoute);
            break;
        }
        ctx.unloadAllData();
        return results;
    }

    private List<RouteSegmentResult> searchRoute(RoutingContext ctx, BinaryRoutePlanner.RouteSegmentPoint start, BinaryRoutePlanner.RouteSegmentPoint end, PrecalculatedRouteDirection routeDirection) throws IOException, InterruptedException {
        List<RouteSegmentResult> result = this.searchRouteInternalPrepare(ctx, start, end, routeDirection);
        return result;
    }

    public static enum RouteCalculationMode {
        BASE,
        NORMAL,
        COMPLEX;

    }
}

