/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.action.support;

import org.opensearch.action.ActionRequest;
import org.opensearch.action.support.ActionFilters;
import org.opensearch.action.support.ChannelActionListener;
import org.opensearch.action.support.TransportAction;
import org.opensearch.core.action.ActionResponse;
import org.opensearch.core.common.io.stream.Writeable;
import org.opensearch.ratelimitting.admissioncontrol.enums.AdmissionControlActionType;
import org.opensearch.tasks.Task;
import org.opensearch.transport.TransportChannel;
import org.opensearch.transport.TransportRequestHandler;
import org.opensearch.transport.TransportService;

public abstract class HandledTransportAction<Request extends ActionRequest, Response extends ActionResponse>
extends TransportAction<Request, Response> {
    protected HandledTransportAction(String actionName, TransportService transportService, ActionFilters actionFilters, Writeable.Reader<Request> requestReader) {
        this(actionName, true, transportService, actionFilters, requestReader);
    }

    protected HandledTransportAction(String actionName, TransportService transportService, ActionFilters actionFilters, Writeable.Reader<Request> requestReader, String executor) {
        this(actionName, true, null, transportService, actionFilters, requestReader, executor);
    }

    protected HandledTransportAction(String actionName, boolean canTripCircuitBreaker, TransportService transportService, ActionFilters actionFilters, Writeable.Reader<Request> requestReader) {
        this(actionName, canTripCircuitBreaker, null, transportService, actionFilters, requestReader, "same");
    }

    protected HandledTransportAction(String actionName, boolean canTripCircuitBreaker, AdmissionControlActionType admissionControlActionType, TransportService transportService, ActionFilters actionFilters, Writeable.Reader<Request> requestReader) {
        this(actionName, canTripCircuitBreaker, admissionControlActionType, transportService, actionFilters, requestReader, "same");
    }

    protected HandledTransportAction(String actionName, boolean canTripCircuitBreaker, AdmissionControlActionType admissionControlActionType, TransportService transportService, ActionFilters actionFilters, Writeable.Reader<Request> requestReader, String executor) {
        super(actionName, actionFilters, transportService.getTaskManager());
        transportService.registerRequestHandler(actionName, executor, false, canTripCircuitBreaker, admissionControlActionType, requestReader, new TransportHandler());
    }

    class TransportHandler
    implements TransportRequestHandler<Request> {
        TransportHandler() {
        }

        @Override
        public final void messageReceived(Request request, TransportChannel channel, Task task) {
            HandledTransportAction.this.execute(task, request, new ChannelActionListener(channel, HandledTransportAction.this.actionName, request));
        }
    }
}

