/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.redshift.jdbc;

import com.amazon.redshift.core.BaseStatement;
import com.amazon.redshift.core.Field;
import com.amazon.redshift.core.Tuple;
import com.amazon.redshift.core.Utils;
import com.amazon.redshift.jdbc.RedshiftConnectionImpl;
import com.amazon.redshift.util.RedshiftException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class MetadataAPIHelper {
    protected final RedshiftConnectionImpl connection;
    protected final Field[] GET_CATALOGS_COLS;
    protected final Field[] GET_SCHEMAS_COLS;
    protected final Field[] GET_TABLES_COLS;
    protected final Field[] GET_COLUMNS_COLS;
    protected final Field[] GET_PRIMARY_KEYS_COLS;
    protected final Field[] GET_FOREIGN_KEYS_COLS;
    protected final Field[] GET_BEST_ROW_IDENTIFIER_COLS;
    protected final Field[] GET_COLUMN_PRIVILEGES_COLS;
    protected final Field[] GET_TABLE_PRIVILEGES_COLS;
    protected final Field[] GET_PROCEDURES_COLS;
    protected final Field[] GET_PROCEDURES_COLUMNS_COLS;
    protected final Field[] GET_FUNCTIONS_COLS;
    protected final Field[] GET_FUNCTIONS_COLUMNS_COLS;
    protected final Field[] GET_TABLE_TYPE_COLS;
    protected final short IMPORTED_KEY_NO_ACTION = (short)3;
    protected final short IMPORTED_KEY_NOT_DEFERRABLE = (short)7;
    public static final String SHOW_DATABASES_DATABASE_NAME = "database_name";
    public static final String SHOW_SCHEMAS_DATABASE_NAME = "database_name";
    public static final String SHOW_SCHEMAS_SCHEMA_NAME = "schema_name";
    public static final String SHOW_TABLES_DATABASE_NAME = "database_name";
    public static final String SHOW_TABLES_SCHEMA_NAME = "schema_name";
    public static final String SHOW_TABLES_TABLE_NAME = "table_name";
    public static final String SHOW_TABLES_TABLE_TYPE = "table_type";
    public static final String SHOW_TABLES_REMARKS = "remarks";
    public static final String SHOW_TABLES_OWNER = "owner";
    public static final String SHOW_TABLES_LAST_ALTERED_TIME = "last_altered_time";
    public static final String SHOW_TABLES_LAST_MODIFIED_TIME = "last_modified_time";
    public static final String SHOW_TABLES_DIST_STYLE = "dist_style";
    public static final String SHOW_TABLES_TABLE_SUBTYPE = "table_subtype";
    public static final String SHOW_COLUMNS_DATABASE_NAME = "database_name";
    public static final String SHOW_COLUMNS_SCHEMA_NAME = "schema_name";
    public static final String SHOW_COLUMNS_TABLE_NAME = "table_name";
    public static final String SHOW_COLUMNS_COLUMN_NAME = "column_name";
    public static final String SHOW_COLUMNS_ORDINAL_POSITION = "ordinal_position";
    public static final String SHOW_COLUMNS_COLUMN_DEFAULT = "column_default";
    public static final String SHOW_COLUMNS_IS_NULLABLE = "is_nullable";
    public static final String SHOW_COLUMNS_DATA_TYPE = "data_type";
    public static final String SHOW_COLUMNS_CHARACTER_MAXIMUM_LENGTH = "character_maximum_length";
    public static final String SHOW_COLUMNS_NUMERIC_PRECISION = "numeric_precision";
    public static final String SHOW_COLUMNS_NUMERIC_SCALE = "numeric_scale";
    public static final String SHOW_COLUMNS_REMARKS = "remarks";
    public static final String SHOW_COLUMNS_SORT_KEY_TYPE = "sort_key_type";
    public static final String SHOW_COLUMNS_SORT_KEY = "sort_key";
    public static final String SHOW_COLUMNS_DIST_KEY = "dist_key";
    public static final String SHOW_COLUMNS_ENCODING = "encoding";
    public static final String SHOW_COLUMNS_COLLATION = "collation";
    public static final String SHOW_PRIMARY_KEYS_DATABASE_NAME = "database_name";
    public static final String SHOW_PRIMARY_KEYS_SCHEMA_NAME = "schema_name";
    public static final String SHOW_PRIMARY_KEYS_TABLE_NAME = "table_name";
    public static final String SHOW_PRIMARY_KEYS_COLUMN_NAME = "column_name";
    public static final String SHOW_PRIMARY_KEYS_KEY_SEQ = "key_seq";
    public static final String SHOW_PRIMARY_KEYS_PK_NAME = "pk_name";
    public static final String SHOW_FOREIGN_KEYS_PK_DATABASE_NAME = "pk_database_name";
    public static final String SHOW_FOREIGN_KEYS_PK_SCHEMA_NAME = "pk_schema_name";
    public static final String SHOW_FOREIGN_KEYS_PK_TABLE_NAME = "pk_table_name";
    public static final String SHOW_FOREIGN_KEYS_PK_COLUMN_NAME = "pk_column_name";
    public static final String SHOW_FOREIGN_KEYS_FK_DATABASE_NAME = "fk_database_name";
    public static final String SHOW_FOREIGN_KEYS_FK_SCHEMA_NAME = "fk_schema_name";
    public static final String SHOW_FOREIGN_KEYS_FK_TABLE_NAME = "fk_table_name";
    public static final String SHOW_FOREIGN_KEYS_FK_COLUMN_NAME = "fk_column_name";
    public static final String SHOW_FOREIGN_KEYS_KEY_SEQ = "key_seq";
    public static final String SHOW_FOREIGN_KEYS_UPDATE_RULE = "update_rule";
    public static final String SHOW_FOREIGN_KEYS_DELETE_RULE = "delete_rule";
    public static final String SHOW_FOREIGN_KEYS_FK_NAME = "fk_name";
    public static final String SHOW_FOREIGN_KEYS_PK_NAME = "pk_name";
    public static final String SHOW_FOREIGN_KEYS_DEFERRABILITY = "deferrability";
    public static final String SHOW_GRANT_DATABASE_NAME = "database_name";
    public static final String SHOW_GRANT_SCHEMA_NAME = "schema_name";
    public static final String SHOW_GRANT_OBJECT_NAME = "object_name";
    public static final String SHOW_GRANT_TABLE_NAME = "table_name";
    public static final String SHOW_GRANT_COLUMN_NAME = "column_name";
    public static final String SHOW_GRANT_GRANTOR = "grantor_name";
    public static final String SHOW_GRANT_IDENTITY_NAME = "identity_name";
    public static final String SHOW_GRANT_PRIVILEGE_TYPE = "privilege_type";
    public static final String SHOW_GRANT_ADMIN_OPTION = "admin_option";
    public static final String SHOW_PROCEDURES_DATABASE_NAME = "database_name";
    public static final String SHOW_PROCEDURES_SCHEMA_NAME = "schema_name";
    public static final String SHOW_PROCEDURES_PROCEDURE_NAME = "procedure_name";
    public static final String SHOW_PROCEDURES_RETURN_TYPE = "return_type";
    public static final String SHOW_PROCEDURES_ARGUMENT_LIST = "argument_list";
    public static final String SHOW_FUNCTIONS_DATABASE_NAME = "database_name";
    public static final String SHOW_FUNCTIONS_SCHEMA_NAME = "schema_name";
    public static final String SHOW_FUNCTIONS_FUNCTION_NAME = "function_name";
    public static final String SHOW_FUNCTIONS_RETURN_TYPE = "return_type";
    public static final String SHOW_FUNCTIONS_ARGUMENT_LIST = "argument_list";
    public static final String SHOW_PARAMETERS_DATABASE_NAME = "database_name";
    public static final String SHOW_PARAMETERS_SCHEMA_NAME = "schema_name";
    public static final String SHOW_PARAMETERS_PROCEDURE_NAME = "procedure_name";
    public static final String SHOW_PARAMETERS_FUNCTION_NAME = "function_name";
    public static final String SHOW_PARAMETERS_PARAMETER_NAME = "parameter_name";
    public static final String SHOW_PARAMETERS_ORDINAL_POSITION = "ordinal_position";
    public static final String SHOW_PARAMETERS_PARAMETER_TYPE = "parameter_type";
    public static final String SHOW_PARAMETERS_DATA_TYPE = "data_type";
    public static final String SHOW_PARAMETERS_CHARACTER_MAXIMUM_LENGTH = "character_maximum_length";
    public static final String SHOW_PARAMETERS_NUMERIC_PRECISION = "numeric_precision";
    public static final String SHOW_PARAMETERS_NUMERIC_SCALE = "numeric_scale";
    protected final String SQL_PREP_SHOWDATABASES = "SHOW DATABASES;";
    protected final String SQL_PREP_SHOWSCHEMAS = "SHOW SCHEMAS FROM DATABASE ?;";
    protected final String SQL_PREP_SHOWSCHEMASLIKE = "SHOW SCHEMAS FROM DATABASE ? LIKE ?;";
    protected final String SQL_PREP_SHOWTABLES = "SHOW TABLES FROM SCHEMA ?.?;";
    protected final String SQL_PREP_SHOWTABLESLIKE = "SHOW TABLES FROM SCHEMA ?.? LIKE ?;";
    protected final String SQL_PREP_SHOWCOLUMNS = "SHOW COLUMNS FROM TABLE ?.?.?";
    protected final String SQL_PREP_SHOWCOLUMNSLIKE = "SHOW COLUMNS FROM TABLE ?.?.? LIKE ?;";
    protected final String SQL_PREP_SHOWPRIMARYKEYS = "SHOW CONSTRAINTS PRIMARY KEYS FROM TABLE ?.?.?;";
    protected final String SQL_PREP_SHOWFOREIGNKEYS = "SHOW CONSTRAINTS FOREIGN KEYS FROM TABLE ?.?.?;";
    protected final String SQL_PREP_SHOWFOREIGNEXPORTEDKEYS = "SHOW CONSTRAINTS FOREIGN KEYS EXPORTED FROM TABLE ?.?.?;";
    protected final String SQL_PREP_SHOWGRANTSCOLUMN = "SHOW COLUMN GRANTS ON TABLE ?.?.?;";
    protected final String SQL_PREP_SHOWGRANTSCOLUMNLIKE = "SHOW COLUMN GRANTS ON TABLE ?.?.? LIKE ?;";
    protected final String SQL_PREP_SHOWGRANTSTABLE = "SHOW GRANTS ON TABLE ?.?.?;";
    protected final String SQL_PREP_SHOWPROCEDURES = "SHOW PROCEDURES FROM SCHEMA ?.?;";
    protected final String SQL_PREP_SHOWPROCEDURESLIKE = "SHOW PROCEDURES FROM SCHEMA ?.? LIKE ?;";
    protected final String SQL_PREP_SHOWFUNCTIONS = "SHOW FUNCTIONS FROM SCHEMA ?.?;";
    protected final String SQL_PREP_SHOWFUNCTIONSLIKE = "SHOW FUNCTIONS FROM SCHEMA ?.? LIKE ?;";
    protected final String SQL_PREP_SHOWPARAMETERSPROCEDURE = "SHOW PARAMETERS OF PROCEDURE ?.?.?";
    protected final String SQL_PREP_SHOWPARAMETERSFUNCTION = "SHOW PARAMETERS OF FUNCTION ?.?.?";
    protected final String SQL_SEMICOLON = ";";
    protected final String SQL_LIKE = " LIKE ?;";
    protected static final String DATETIME_PRECISION_PATTERN = "(time|timetz|timestamp|timestamptz)\\(\\d+\\).*";
    protected static final String INTERVAL_PRECISION_PATTERN = "interval.*.\\(\\d+\\)";
    protected static final String PRECISION_EXTRACTION_PATTERN = ".*\\(([0-9]+)\\).*";
    protected static final String PRECISION_REMOVAL_PATTERN = "\\(\\d+\\)";
    protected static final String TRAILING_SPACES_PATTERN = "\\s++$";
    protected static final String RADIX_VALUE = "10";
    protected static final String NULLABLE_UNKNOWN_VALUE = "2";
    protected static final String EMPTY_REMARKS = "";
    protected static final String IS_NULLABLE_VALUE = "";
    protected static final String PSEUDO_COLUMN_VALUE = "1";
    protected static final Map<String, Integer> PROCEDURE_COLUMN_TYPE_MAP;
    protected static final Map<String, Integer> FUNCTION_COLUMN_TYPE_MAP;
    private static final Map<String, String> rsTypeMap;
    private static final Map<String, Integer> rsColumnSizeMap;

    public MetadataAPIHelper(RedshiftConnectionImpl connection) {
        this.connection = connection;
        this.GET_CATALOGS_COLS = this.getCatalogsField();
        this.GET_SCHEMAS_COLS = this.getSchemasField();
        this.GET_TABLES_COLS = this.getTablesField();
        this.GET_COLUMNS_COLS = this.getColumnsField();
        this.GET_PRIMARY_KEYS_COLS = this.getPrimaryKeysField();
        this.GET_FOREIGN_KEYS_COLS = this.getForeignKeysField();
        this.GET_BEST_ROW_IDENTIFIER_COLS = this.getBestRowIdentifierField();
        this.GET_COLUMN_PRIVILEGES_COLS = this.getColumnPrivileges();
        this.GET_TABLE_PRIVILEGES_COLS = this.getTablePrivileges();
        this.GET_PROCEDURES_COLS = this.getProcedures();
        this.GET_PROCEDURES_COLUMNS_COLS = this.getProceduresColumns();
        this.GET_FUNCTIONS_COLS = this.getFunctions();
        this.GET_FUNCTIONS_COLUMNS_COLS = this.getFunctionsColumns();
        this.GET_TABLE_TYPE_COLS = this.getTableType();
    }

    public static <T extends Enum<T>> Field[] getField(Supplier<T[]> enumObject) {
        Enum[] enumValue = (Enum[])enumObject.get();
        Field[] columns = new Field[enumValue.length];
        for (Enum metadata : enumValue) {
            columns[((enumFunc)((Object)metadata)).getIndex()] = new Field(((enumFunc)((Object)metadata)).getName(), ((enumFunc)((Object)metadata)).getOidType());
        }
        return columns;
    }

    private Field[] getCatalogsField() {
        return MetadataAPIHelper.getField(GetCatalogs_Metadata::values);
    }

    private Field[] getSchemasField() {
        return MetadataAPIHelper.getField(GetSchemas_Metadata::values);
    }

    private Field[] getTablesField() {
        return MetadataAPIHelper.getField(GetTables_Metadata::values);
    }

    private Field[] getColumnsField() {
        return MetadataAPIHelper.getField(GetColumns_Metadata::values);
    }

    private Field[] getPrimaryKeysField() {
        return MetadataAPIHelper.getField(GetPrimaryKeys_Metadata::values);
    }

    private Field[] getForeignKeysField() {
        return MetadataAPIHelper.getField(GetForeignKeys_Metadata::values);
    }

    private Field[] getBestRowIdentifierField() {
        return MetadataAPIHelper.getField(GetBestRowIdentifier_Metadata::values);
    }

    private Field[] getTableType() {
        return MetadataAPIHelper.getField(GetTableType_Metadata::values);
    }

    private Field[] getFunctionsColumns() {
        return MetadataAPIHelper.getField(GetFunctionsColumns_Metadata::values);
    }

    private Field[] getFunctions() {
        return MetadataAPIHelper.getField(GetFunctions_Metadata::values);
    }

    private Field[] getProceduresColumns() {
        return MetadataAPIHelper.getField(GetProceduresColumns_Metadata::values);
    }

    private Field[] getProcedures() {
        return MetadataAPIHelper.getField(GetProcedures_Metadata::values);
    }

    private Field[] getTablePrivileges() {
        return MetadataAPIHelper.getField(GetTablePrivileges_Metadata::values);
    }

    private Field[] getColumnPrivileges() {
        return MetadataAPIHelper.getField(GetColumnPrivileges_Metadata::values);
    }

    protected Statement createMetaDataStatement() throws SQLException {
        return this.connection.createStatement(1004, 1007);
    }

    protected PreparedStatement createMetaDataPreparedStatement(String sql) throws SQLException {
        return this.connection.prepareStatement(sql);
    }

    protected ResultSet createRs(Field[] col, List<Tuple> data) throws SQLException {
        return ((BaseStatement)this.createMetaDataStatement()).createDriverResultSet(col, data);
    }

    protected ResultSet runQuery(String sql) throws SQLException {
        return this.createMetaDataStatement().executeQuery(sql);
    }

    protected byte[][] getEmptyTuple(Field[] col, int size) throws SQLException {
        byte[][] tuple = new byte[size][];
        byte[] temStr = this.encodeStr("");
        byte[] temNum = this.encodeStr("0");
        for (int i = 0; i < size; ++i) {
            tuple[i] = col[i].getOID() == 1043 ? temStr : temNum;
        }
        return tuple;
    }

    protected byte[] encodeStr(String str) throws SQLException {
        return this.connection.encodeString(str);
    }

    protected String getRSType(String rsType) throws SQLException {
        return rsTypeMap.getOrDefault(rsType, rsType);
    }

    protected String getSQLType(String rsType) throws SQLException {
        return Integer.toString(this.connection.getTypeInfo().getSQLType(rsType));
    }

    protected String getColumnSize(String rsType, String character_maximum_length, String numeric_precision) {
        switch (rsType) {
            case "decimal": 
            case "numeric": {
                return numeric_precision;
            }
            case "varchar": 
            case "character varying": 
            case "char": 
            case "character": 
            case "nchar": 
            case "bpchar": 
            case "nvarchar": {
                return character_maximum_length;
            }
            case "geometry": 
            case "super": 
            case "varbyte": 
            case "geography": {
                return null;
            }
        }
        return Integer.toString(rsColumnSizeMap.getOrDefault(rsType, Integer.MAX_VALUE));
    }

    protected String getColumnLength(String rsType) {
        if (rsType == null) {
            return null;
        }
        switch (rsType) {
            case "bool": 
            case "bit": 
            case "boolean": {
                return PSEUDO_COLUMN_VALUE;
            }
            case "int2": 
            case "smallint": {
                return NULLABLE_UNKNOWN_VALUE;
            }
            case "int4": 
            case "integer": 
            case "int": {
                return "4";
            }
            case "int8": 
            case "bigint": {
                return "20";
            }
            case "float4": 
            case "real": {
                return "4";
            }
            case "float8": 
            case "double precision": {
                return "8";
            }
            case "date": {
                return "6";
            }
            case "time": {
                return "15";
            }
            case "timetz": {
                return "21";
            }
            case "timestamp": {
                return "6";
            }
            case "timestamptz": {
                return "35";
            }
            case "intervaly2m": {
                return "4";
            }
            case "intervald2s": {
                return "8";
            }
            case "super": {
                return "4194304";
            }
            case "geography": 
            case "varbyte": {
                return "1000000";
            }
        }
        return null;
    }

    protected String getDecimalDigit(String rsType, String numeric_scale, int precision, boolean customizePrecision) {
        switch (rsType) {
            case "float4": 
            case "real": {
                return "8";
            }
            case "float8": 
            case "double precision": {
                return "17";
            }
            case "time": 
            case "time without time zone": 
            case "timetz": 
            case "time with time zone": 
            case "timestamp": 
            case "timestamp without time zone": 
            case "timestamptz": 
            case "timestamp with time zone": 
            case "intervald2s": {
                return customizePrecision ? String.valueOf(precision) : "6";
            }
            case "intervaly2m": {
                return customizePrecision ? String.valueOf(precision) : "0";
            }
            case "geometry": 
            case "super": 
            case "varbyte": 
            case "geography": {
                return null;
            }
            case "numeric": {
                return numeric_scale;
            }
        }
        return "0";
    }

    protected String getNumPrefixRadix(String rsType) {
        switch (rsType) {
            case "varbyte": 
            case "geography": {
                return NULLABLE_UNKNOWN_VALUE;
            }
        }
        return RADIX_VALUE;
    }

    protected String getNullable(String nullable) {
        switch (nullable) {
            case "YES": {
                return Integer.toString(1);
            }
            case "NO": {
                return Integer.toString(0);
            }
        }
        return Integer.toString(2);
    }

    protected String getAutoIncrement(String colDef) {
        if (colDef != null && (colDef.contains("\"identity\"") || colDef.contains("default_identity"))) {
            return "YES";
        }
        return "NO";
    }

    protected String getSpecificName(String name, String argument) throws SQLException {
        if (Utils.isNullOrEmpty(name)) {
            throw new RedshiftException("Function/Procedure name cannot be null or empty");
        }
        argument = argument == null ? "" : argument;
        return name + "(" + argument + ")";
    }

    protected Map.Entry<String, List<String>> createParameterizedQueryString(String argumentList, String sqlBase, String columnNamePattern) throws SQLException {
        if (Utils.isNullOrEmpty(sqlBase)) {
            throw new RedshiftException("SQL base cannot be null or empty");
        }
        if (Utils.isNullOrEmpty(argumentList)) {
            String sql = sqlBase + "()" + (Utils.isNullOrEmpty(columnNamePattern) ? ";" : " LIKE ?;");
            return new AbstractMap.SimpleEntry<String, List<String>>(sql, new ArrayList());
        }
        List args = Arrays.stream(argumentList.split(",")).map(String::trim).collect(Collectors.toList());
        List invalidTypes = RedshiftDataTypes.validateTypes(args);
        if (!invalidTypes.isEmpty()) {
            throw new RedshiftException(String.format("Invalid data type(s) in argument list: %s. Argument list provided: %s", String.join((CharSequence)", ", invalidTypes), argumentList));
        }
        String placeholders = String.join((CharSequence)", ", (CharSequence[])Arrays.stream(new String[args.size()]).map(s -> "?").toArray(String[]::new));
        String sql = String.format("%s(%s)%s", sqlBase, placeholders, Utils.isNullOrEmpty(columnNamePattern) ? ";" : " LIKE ?;");
        return new AbstractMap.SimpleEntry<String, List<String>>(sql, args);
    }

    protected static int getProcedureType(String returnType) {
        if (Utils.isNullOrEmpty(returnType)) {
            return 1;
        }
        return 2;
    }

    protected static int getFunctionType(String returnType) {
        if (returnType != null && returnType.equals("record")) {
            return 2;
        }
        return 1;
    }

    protected static int getProcedureColumnType(String parameterType) {
        if (Utils.isNullOrEmpty(parameterType)) {
            return 0;
        }
        return PROCEDURE_COLUMN_TYPE_MAP.getOrDefault(parameterType.toUpperCase(), 0);
    }

    protected static int getFunctionColumnType(String parameterType) {
        if (Utils.isNullOrEmpty(parameterType)) {
            return 0;
        }
        return FUNCTION_COLUMN_TYPE_MAP.getOrDefault(parameterType.toUpperCase(), 0);
    }

    protected static void sortForeignKeyTuples(List<Tuple> foreignKeyTuples, boolean isImported) {
        Collections.sort(foreignKeyTuples, (t1, t2) -> {
            int comparedCol = isImported ? ForeignKeyColumnIndex.PK_CATALOG.getIndex() : ForeignKeyColumnIndex.FK_CATALOG.getIndex();
            int comparison = MetadataAPIHelper.compareBytes(t1.get(comparedCol), t2.get(comparedCol));
            if (comparison != 0) {
                return comparison;
            }
            comparedCol = isImported ? ForeignKeyColumnIndex.PK_SCHEMA.getIndex() : ForeignKeyColumnIndex.FK_SCHEMA.getIndex();
            comparison = MetadataAPIHelper.compareBytes(t1.get(comparedCol), t2.get(comparedCol));
            if (comparison != 0) {
                return comparison;
            }
            comparedCol = isImported ? ForeignKeyColumnIndex.PK_TABLE.getIndex() : ForeignKeyColumnIndex.FK_TABLE.getIndex();
            comparison = MetadataAPIHelper.compareBytes(t1.get(comparedCol), t2.get(comparedCol));
            if (comparison != 0) {
                return comparison;
            }
            return MetadataAPIHelper.compareBytes(t1.get(ForeignKeyColumnIndex.KEY_SEQ.getIndex()), t2.get(ForeignKeyColumnIndex.KEY_SEQ.getIndex()));
        });
    }

    private static int compareBytes(byte[] b1, byte[] b2) {
        if (b1 == null && b2 == null) {
            return 0;
        }
        if (b1 == null) {
            return -1;
        }
        if (b2 == null) {
            return 1;
        }
        int length = Math.min(b1.length, b2.length);
        for (int i = 0; i < length; ++i) {
            int diff = Byte.toUnsignedInt(b1[i]) - Byte.toUnsignedInt(b2[i]);
            if (diff == 0) continue;
            return diff;
        }
        return Integer.compare(b1.length, b2.length);
    }

    protected static String getIsGrantable(Boolean admin_option) {
        return admin_option == null ? "NO" : (admin_option != false ? "YES" : "NO");
    }

    public static boolean patternMatch(String str, String pattern) {
        if (pattern == null || pattern.isEmpty()) {
            return true;
        }
        String regexPattern = MetadataAPIHelper.convertSqlLikeToRegex(pattern);
        Pattern compiledPattern = Pattern.compile(regexPattern, 32);
        Matcher matcher = compiledPattern.matcher(str);
        return matcher.matches();
    }

    public static String convertSqlLikeToRegex(String pattern) {
        if (pattern == null || pattern.isEmpty()) {
            return ".*";
        }
        boolean onlyPercent = true;
        for (char c : pattern.toCharArray()) {
            if (c == '%') continue;
            onlyPercent = false;
            break;
        }
        if (onlyPercent) {
            return ".*";
        }
        StringBuilder regexPattern = new StringBuilder();
        int i = 0;
        while (i < pattern.length()) {
            char ch = pattern.charAt(i);
            if (ch == '\\' && i + 1 < pattern.length()) {
                char nextChar = pattern.charAt(i + 1);
                if (nextChar == '%' || nextChar == '_' || nextChar == '\\') {
                    regexPattern.append(Pattern.quote(String.valueOf(nextChar)));
                    i += 2;
                    continue;
                }
                regexPattern.append(Pattern.quote(String.valueOf(ch)));
                ++i;
                continue;
            }
            if (ch == '%') {
                regexPattern.append(".*");
                ++i;
                continue;
            }
            if (ch == '_') {
                regexPattern.append(".");
                ++i;
                continue;
            }
            regexPattern.append(Pattern.quote(String.valueOf(ch)));
            ++i;
        }
        return "^" + regexPattern.toString() + "$";
    }

    static {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        map.put("IN", 1);
        map.put("OUT", 4);
        map.put("INOUT", 2);
        map.put("TABLE", 3);
        map.put("RETURN", 5);
        PROCEDURE_COLUMN_TYPE_MAP = Collections.unmodifiableMap(map);
        map = new HashMap();
        map.put("IN", 1);
        map.put("OUT", 3);
        map.put("INOUT", 2);
        map.put("TABLE", 5);
        map.put("RETURN", 4);
        FUNCTION_COLUMN_TYPE_MAP = Collections.unmodifiableMap(map);
        rsTypeMap = new HashMap<String, String>();
        rsTypeMap.put("character varying", "varchar");
        rsTypeMap.put("\"char\"", "char");
        rsTypeMap.put("character", "char");
        rsTypeMap.put("smallint", "int2");
        rsTypeMap.put("integer", "int4");
        rsTypeMap.put("bigint", "int8");
        rsTypeMap.put("real", "float4");
        rsTypeMap.put("double precision", "float8");
        rsTypeMap.put("boolean", "bool");
        rsTypeMap.put("time without time zone", "time");
        rsTypeMap.put("time with time zone", "timetz");
        rsTypeMap.put("timestamp without time zone", "timestamp");
        rsTypeMap.put("timestamp with time zone", "timestamptz");
        rsTypeMap.put("interval year to month", "intervaly2m");
        rsTypeMap.put("interval year", "intervaly2m");
        rsTypeMap.put("interval month", "intervaly2m");
        rsTypeMap.put("interval day to second", "intervald2s");
        rsTypeMap.put("interval day", "intervald2s");
        rsTypeMap.put("interval second", "intervald2s");
        rsColumnSizeMap = new HashMap<String, Integer>();
        rsColumnSizeMap.put("bit", 1);
        rsColumnSizeMap.put("bool", 1);
        rsColumnSizeMap.put("int2", 5);
        rsColumnSizeMap.put("int4", 10);
        rsColumnSizeMap.put("int8", 19);
        rsColumnSizeMap.put("float4", 8);
        rsColumnSizeMap.put("float8", 17);
        rsColumnSizeMap.put("date", 13);
        rsColumnSizeMap.put("time", 15);
        rsColumnSizeMap.put("timetz", 21);
        rsColumnSizeMap.put("timestamp", 29);
        rsColumnSizeMap.put("timestamptz", 35);
        rsColumnSizeMap.put("intervaly2m", 32);
        rsColumnSizeMap.put("intervald2s", 64);
    }

    public static class ShowParametersInfo {
        private final String databaseName;
        private final String schemaName;
        private final String procedureName;
        private final String functionName;
        private final String parameterName;
        private final String ordinalPosition;
        private final String parameterType;
        private final String dataType;
        private final String characterMaximumLength;
        private final String numericPrecision;
        private final String numericScale;

        public ShowParametersInfo(String databaseName, String schemaName, String procedureName, String functionName, String parameterName, String ordinalPosition, String parameterType, String dataType, String characterMaximumLength, String numericPrecision, String numericScale) {
            this.databaseName = databaseName;
            this.schemaName = schemaName;
            this.procedureName = procedureName;
            this.functionName = functionName;
            this.parameterName = parameterName;
            this.ordinalPosition = ordinalPosition;
            this.parameterType = parameterType;
            this.dataType = dataType;
            this.characterMaximumLength = characterMaximumLength;
            this.numericPrecision = numericPrecision;
            this.numericScale = numericScale;
        }

        public String getDatabaseName() {
            return this.databaseName;
        }

        public String getSchemaName() {
            return this.schemaName;
        }

        public String getProcedureName() {
            return this.procedureName;
        }

        public String getFunctionName() {
            return this.functionName;
        }

        public String getParameterName() {
            return this.parameterName;
        }

        public String getOrdinalPosition() {
            return this.ordinalPosition;
        }

        public String getParameterType() {
            return this.parameterType;
        }

        public String getDataType() {
            return this.dataType;
        }

        public String getCharacterMaximumLength() {
            return this.characterMaximumLength;
        }

        public String getNumericPrecision() {
            return this.numericPrecision;
        }

        public String getNumericScale() {
            return this.numericScale;
        }
    }

    public static class ShowFunctionsInfo {
        private final String databaseName;
        private final String schemaName;
        private final String functionName;
        private final String returnType;
        private final String argumentList;

        public ShowFunctionsInfo(String databaseName, String schemaName, String functionName, String returnType, String argumentList) {
            this.databaseName = databaseName;
            this.schemaName = schemaName;
            this.functionName = functionName;
            this.returnType = returnType;
            this.argumentList = argumentList;
        }

        public ShowFunctionsInfo(String functionName, String argumentList) {
            this(null, null, functionName, null, argumentList);
        }

        public String getDatabaseName() {
            return this.databaseName;
        }

        public String getSchemaName() {
            return this.schemaName;
        }

        public String getFunctionName() {
            return this.functionName;
        }

        public String getReturnType() {
            return this.returnType;
        }

        public String getArgumentList() {
            return this.argumentList;
        }
    }

    public static class ShowProceduresInfo {
        private final String databaseName;
        private final String schemaName;
        private final String procedureName;
        private final String returnType;
        private final String argumentList;

        public ShowProceduresInfo(String databaseName, String schemaName, String procedureName, String returnType, String argumentList) {
            this.databaseName = databaseName;
            this.schemaName = schemaName;
            this.procedureName = procedureName;
            this.returnType = returnType;
            this.argumentList = argumentList;
        }

        public ShowProceduresInfo(String procedureName, String argumentList) {
            this(null, null, procedureName, null, argumentList);
        }

        public String getDatabaseName() {
            return this.databaseName;
        }

        public String getSchemaName() {
            return this.schemaName;
        }

        public String getProcedureName() {
            return this.procedureName;
        }

        public String getReturnType() {
            return this.returnType;
        }

        public String getArgumentList() {
            return this.argumentList;
        }
    }

    public static class ShowGrantsInfo {
        private final String databaseName;
        private final String schemaName;
        private final String objectName;
        private final String tableName;
        private final String columnName;
        private final String grantor;
        private final String identityName;
        private final String privilegeType;
        private final boolean adminOption;

        public ShowGrantsInfo(String databaseName, String schemaName, String objectName, String tableName, String columnName, String grantor, String identityName, String privilegeType, boolean adminOption) {
            this.databaseName = databaseName;
            this.schemaName = schemaName;
            this.objectName = objectName;
            this.tableName = tableName;
            this.columnName = columnName;
            this.grantor = grantor;
            this.identityName = identityName;
            this.privilegeType = privilegeType;
            this.adminOption = adminOption;
        }

        public String getDatabaseName() {
            return this.databaseName;
        }

        public String getSchemaName() {
            return this.schemaName;
        }

        public String getObjectName() {
            return this.objectName;
        }

        public String getTableName() {
            return this.tableName;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public String getGrantor() {
            return this.grantor;
        }

        public String getIdentityName() {
            return this.identityName;
        }

        public String getPrivilegeType() {
            return this.privilegeType;
        }

        public boolean getAdminOption() {
            return this.adminOption;
        }
    }

    public static class ShowForeignKeysInfo {
        private final String pkDatabaseName;
        private final String pkSchemaName;
        private final String pkTableName;
        private final String pkColumnName;
        private final String fkDatabaseName;
        private final String fkSchemaName;
        private final String fkTableName;
        private final String fkColumnName;
        private final String keySeq;
        private final String updateRule;
        private final String deleteRule;
        private final String fkName;
        private final String pkName;
        private final String deferrability;

        public ShowForeignKeysInfo(String pkDatabaseName, String pkSchemaName, String pkTableName, String pkColumnName, String fkDatabaseName, String fkSchemaName, String fkTableName, String fkColumnName, String keySeq, String updateRule, String deleteRule, String fkName, String pkName, String deferrability) {
            this.pkDatabaseName = pkDatabaseName;
            this.pkSchemaName = pkSchemaName;
            this.pkTableName = pkTableName;
            this.pkColumnName = pkColumnName;
            this.fkDatabaseName = fkDatabaseName;
            this.fkSchemaName = fkSchemaName;
            this.fkTableName = fkTableName;
            this.fkColumnName = fkColumnName;
            this.keySeq = keySeq;
            this.updateRule = updateRule;
            this.deleteRule = deleteRule;
            this.fkName = fkName;
            this.pkName = pkName;
            this.deferrability = deferrability;
        }

        public String getPkDatabaseName() {
            return this.pkDatabaseName;
        }

        public String getPkSchemaName() {
            return this.pkSchemaName;
        }

        public String getPkTableName() {
            return this.pkTableName;
        }

        public String getPkColumnName() {
            return this.pkColumnName;
        }

        public String getFkDatabaseName() {
            return this.fkDatabaseName;
        }

        public String getFkSchemaName() {
            return this.fkSchemaName;
        }

        public String getFkTableName() {
            return this.fkTableName;
        }

        public String getFkColumnName() {
            return this.fkColumnName;
        }

        public String getKeySeq() {
            return this.keySeq;
        }

        public String getUpdateRule() {
            return this.updateRule;
        }

        public String getDeleteRule() {
            return this.deleteRule;
        }

        public String getFkName() {
            return this.fkName;
        }

        public String getPkName() {
            return this.pkName;
        }

        public String getDeferrability() {
            return this.deferrability;
        }
    }

    public static class ShowPrimaryKeysInfo {
        private final String databaseName;
        private final String schemaName;
        private final String tableName;
        private final String columnName;
        private final String keySeq;
        private final String pkName;

        public ShowPrimaryKeysInfo(String databaseName, String schemaName, String tableName, String columnName, String keySeq, String pkName) {
            this.databaseName = databaseName;
            this.schemaName = schemaName;
            this.tableName = tableName;
            this.columnName = columnName;
            this.keySeq = keySeq;
            this.pkName = pkName;
        }

        public ShowPrimaryKeysInfo(String tableName, String columnName) {
            this(null, null, tableName, columnName, null, null);
        }

        public String getDatabaseName() {
            return this.databaseName;
        }

        public String getSchemaName() {
            return this.schemaName;
        }

        public String getTableName() {
            return this.tableName;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public String getKeySeq() {
            return this.keySeq;
        }

        public String getPkName() {
            return this.pkName;
        }
    }

    public static class ShowColumnsInfo {
        private final String databaseName;
        private final String schemaName;
        private final String tableName;
        private final String columnName;
        private final String ordinalPosition;
        private final String columnDefault;
        private final String isNullable;
        private final String dataType;
        private final String characterMaximumLength;
        private final String numericPrecision;
        private final String numericScale;
        private final String remarks;
        private final String sortKeyType;
        private final String sortKey;
        private final String distKey;
        private final String encoding;
        private final String collation;

        public ShowColumnsInfo(String databaseName, String schemaName, String tableName, String columnName, String ordinalPosition, String columnDefault, String isNullable, String dataType, String characterMaximumLength, String numericPrecision, String numericScale, String remarks, String sortKeyType, String sortKey, String distKey, String encoding, String collation) {
            this.databaseName = databaseName;
            this.schemaName = schemaName;
            this.tableName = tableName;
            this.columnName = columnName;
            this.ordinalPosition = ordinalPosition;
            this.columnDefault = columnDefault;
            this.isNullable = isNullable;
            this.dataType = dataType;
            this.characterMaximumLength = characterMaximumLength;
            this.numericPrecision = numericPrecision;
            this.numericScale = numericScale;
            this.remarks = remarks;
            this.sortKeyType = sortKeyType;
            this.sortKey = sortKey;
            this.distKey = distKey;
            this.encoding = encoding;
            this.collation = collation;
        }

        public String getDatabaseName() {
            return this.databaseName;
        }

        public String getSchemaName() {
            return this.schemaName;
        }

        public String getTableName() {
            return this.tableName;
        }

        public String getColumnName() {
            return this.columnName;
        }

        public String getOrdinalPosition() {
            return this.ordinalPosition;
        }

        public String getColumnDefault() {
            return this.columnDefault;
        }

        public String getIsNullable() {
            return this.isNullable;
        }

        public String getDataType() {
            return this.dataType;
        }

        public String getCharacterMaximumLength() {
            return this.characterMaximumLength;
        }

        public String getNumericPrecision() {
            return this.numericPrecision;
        }

        public String getNumericScale() {
            return this.numericScale;
        }

        public String getRemarks() {
            return this.remarks;
        }

        public String getSortKeyType() {
            return this.sortKeyType;
        }

        public String getSortKey() {
            return this.sortKey;
        }

        public String getDistKey() {
            return this.distKey;
        }

        public String getEncoding() {
            return this.encoding;
        }

        public String getCollation() {
            return this.collation;
        }
    }

    public static class ShowTablesInfo {
        private final String databaseName;
        private final String schemaName;
        private final String tableName;
        private final String tableType;
        private final String remarks;
        private final String owner;
        private final String lastAlteredTime;
        private final String lastModifiedTime;
        private final String distStyle;
        private final String tableSubtype;

        public ShowTablesInfo(String databaseName, String schemaName, String tableName, String tableType, String remarks, String owner, String lastAlteredTime, String lastModifiedTime, String distStyle, String tableSubtype) {
            this.databaseName = databaseName;
            this.schemaName = schemaName;
            this.tableName = tableName;
            this.tableType = tableType;
            this.remarks = remarks;
            this.owner = owner;
            this.lastAlteredTime = lastAlteredTime;
            this.lastModifiedTime = lastModifiedTime;
            this.distStyle = distStyle;
            this.tableSubtype = tableSubtype;
        }

        public ShowTablesInfo(String tableName) {
            this(null, null, tableName, null, null, null, null, null, null, null);
        }

        public String getDatabaseName() {
            return this.databaseName;
        }

        public String getSchemaName() {
            return this.schemaName;
        }

        public String getTableName() {
            return this.tableName;
        }

        public String getTableType() {
            return this.tableType;
        }

        public String getRemarks() {
            return this.remarks;
        }

        public String getOwner() {
            return this.owner;
        }

        public String getLastAlteredTime() {
            return this.lastAlteredTime;
        }

        public String getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public String getDistStyle() {
            return this.distStyle;
        }

        public String getTableSubtype() {
            return this.tableSubtype;
        }
    }

    public static class ShowSchemasInfo {
        private final String databaseName;
        private final String schemaName;

        public ShowSchemasInfo(String databaseName, String schemaName) {
            this.databaseName = databaseName;
            this.schemaName = schemaName;
        }

        public ShowSchemasInfo(String schemaName) {
            this(null, schemaName);
        }

        public String getDatabaseName() {
            return this.databaseName;
        }

        public String getSchemaName() {
            return this.schemaName;
        }
    }

    public static interface enumFunc<T extends Enum<T>> {
        public int getIndex();

        public String getName();

        public int getOidType();
    }

    public static enum GetTableType_Metadata implements enumFunc<GetTableType_Metadata>
    {
        TABLE_TYPE(new BaseMetadata(0, "TABLE_TYPE", 1043));

        private final BaseMetadata metadata;

        private GetTableType_Metadata(BaseMetadata metadata) {
            this.metadata = metadata;
        }

        @Override
        public int getIndex() {
            return this.metadata.getIndex();
        }

        @Override
        public String getName() {
            return this.metadata.getName();
        }

        @Override
        public int getOidType() {
            return this.metadata.getOidType();
        }
    }

    public static enum GetFunctionsColumns_Metadata implements enumFunc<GetFunctionsColumns_Metadata>
    {
        FUNCTION_CAT(new BaseMetadata(0, "FUNCTION_CAT", 1043)),
        FUNCTION_SCHEM(new BaseMetadata(1, "FUNCTION_SCHEM", 1043)),
        FUNCTION_NAME(new BaseMetadata(2, "FUNCTION_NAME", 1043)),
        COLUMN_NAME(new BaseMetadata(3, "COLUMN_NAME", 1043)),
        COLUMN_TYPE(new BaseMetadata(4, "COLUMN_TYPE", 21)),
        DATA_TYPE(new BaseMetadata(5, "DATA_TYPE", 23)),
        TYPE_NAME(new BaseMetadata(6, "TYPE_NAME", 1043)),
        PRECISION(new BaseMetadata(7, "PRECISION", 23)),
        LENGTH(new BaseMetadata(8, "LENGTH", 23)),
        SCALE(new BaseMetadata(9, "SCALE", 21)),
        RADIX(new BaseMetadata(10, "RADIX", 21)),
        NULLABLE(new BaseMetadata(11, "NULLABLE", 21)),
        REMARKS(new BaseMetadata(12, "REMARKS", 1043)),
        CHAR_OCTET_LENGTH(new BaseMetadata(13, "CHAR_OCTET_LENGTH", 23)),
        ORDINAL_POSITION(new BaseMetadata(14, "ORDINAL_POSITION", 23)),
        IS_NULLABLE(new BaseMetadata(15, "IS_NULLABLE", 1043)),
        SPECIFIC_NAME(new BaseMetadata(16, "SPECIFIC_NAME", 1043));

        private final BaseMetadata metadata;

        private GetFunctionsColumns_Metadata(BaseMetadata metadata) {
            this.metadata = metadata;
        }

        @Override
        public int getIndex() {
            return this.metadata.getIndex();
        }

        @Override
        public String getName() {
            return this.metadata.getName();
        }

        @Override
        public int getOidType() {
            return this.metadata.getOidType();
        }
    }

    public static enum GetFunctions_Metadata implements enumFunc<GetFunctions_Metadata>
    {
        FUNCTION_CAT(new BaseMetadata(0, "FUNCTION_CAT", 1043)),
        FUNCTION_SCHEM(new BaseMetadata(1, "FUNCTION_SCHEM", 1043)),
        FUNCTION_NAME(new BaseMetadata(2, "FUNCTION_NAME", 1043)),
        REMARKS(new BaseMetadata(3, "REMARKS", 1043)),
        FUNCTION_TYPE(new BaseMetadata(4, "FUNCTION_TYPE", 21)),
        SPECIFIC_NAME(new BaseMetadata(5, "SPECIFIC_NAME", 1043));

        private final BaseMetadata metadata;

        private GetFunctions_Metadata(BaseMetadata metadata) {
            this.metadata = metadata;
        }

        @Override
        public int getIndex() {
            return this.metadata.getIndex();
        }

        @Override
        public String getName() {
            return this.metadata.getName();
        }

        @Override
        public int getOidType() {
            return this.metadata.getOidType();
        }
    }

    public static enum GetProceduresColumns_Metadata implements enumFunc<GetProceduresColumns_Metadata>
    {
        PROCEDURE_CAT(new BaseMetadata(0, "PROCEDURE_CAT", 1043)),
        PROCEDURE_SCHEM(new BaseMetadata(1, "PROCEDURE_SCHEM", 1043)),
        PROCEDURE_NAME(new BaseMetadata(2, "PROCEDURE_NAME", 1043)),
        COLUMN_NAME(new BaseMetadata(3, "COLUMN_NAME", 1043)),
        COLUMN_TYPE(new BaseMetadata(4, "COLUMN_TYPE", 21)),
        DATA_TYPE(new BaseMetadata(5, "DATA_TYPE", 23)),
        TYPE_NAME(new BaseMetadata(6, "TYPE_NAME", 1043)),
        PRECISION(new BaseMetadata(7, "PRECISION", 23)),
        LENGTH(new BaseMetadata(8, "LENGTH", 23)),
        SCALE(new BaseMetadata(9, "SCALE", 21)),
        RADIX(new BaseMetadata(10, "RADIX", 21)),
        NULLABLE(new BaseMetadata(11, "NULLABLE", 21)),
        REMARKS(new BaseMetadata(12, "REMARKS", 1043)),
        COLUMN_DEF(new BaseMetadata(13, "COLUMN_DEF", 1043)),
        SQL_DATA_TYPE(new BaseMetadata(14, "SQL_DATA_TYPE", 23)),
        SQL_DATETIME_SUB(new BaseMetadata(15, "SQL_DATETIME_SUB", 23)),
        CHAR_OCTET_LENGTH(new BaseMetadata(16, "CHAR_OCTET_LENGTH", 23)),
        ORDINAL_POSITION(new BaseMetadata(17, "ORDINAL_POSITION", 23)),
        IS_NULLABLE(new BaseMetadata(18, "IS_NULLABLE", 1043)),
        SPECIFIC_NAME(new BaseMetadata(19, "SPECIFIC_NAME", 1043));

        private final BaseMetadata metadata;

        private GetProceduresColumns_Metadata(BaseMetadata metadata) {
            this.metadata = metadata;
        }

        @Override
        public int getIndex() {
            return this.metadata.getIndex();
        }

        @Override
        public String getName() {
            return this.metadata.getName();
        }

        @Override
        public int getOidType() {
            return this.metadata.getOidType();
        }
    }

    public static enum GetProcedures_Metadata implements enumFunc<GetProcedures_Metadata>
    {
        PROCEDURE_CAT(new BaseMetadata(0, "PROCEDURE_CAT", 1043)),
        PROCEDURE_SCHEM(new BaseMetadata(1, "PROCEDURE_SCHEM", 1043)),
        PROCEDURE_NAME(new BaseMetadata(2, "PROCEDURE_NAME", 1043)),
        RESERVE1(new BaseMetadata(3, "RESERVE1", 1043)),
        RESERVE2(new BaseMetadata(4, "RESERVE2", 1043)),
        RESERVE3(new BaseMetadata(5, "RESERVE3", 1043)),
        REMARKS(new BaseMetadata(6, "REMARKS", 1043)),
        PROCEDURE_TYPE(new BaseMetadata(7, "PROCEDURE_TYPE", 21)),
        SPECIFIC_NAME(new BaseMetadata(8, "SPECIFIC_NAME", 1043));

        private final BaseMetadata metadata;

        private GetProcedures_Metadata(BaseMetadata metadata) {
            this.metadata = metadata;
        }

        @Override
        public int getIndex() {
            return this.metadata.getIndex();
        }

        @Override
        public String getName() {
            return this.metadata.getName();
        }

        @Override
        public int getOidType() {
            return this.metadata.getOidType();
        }
    }

    public static enum GetTablePrivileges_Metadata implements enumFunc<GetTablePrivileges_Metadata>
    {
        TABLE_CAT(new BaseMetadata(0, "TABLE_CAT", 1043)),
        TABLE_SCHEM(new BaseMetadata(1, "TABLE_SCHEM", 1043)),
        TABLE_NAME(new BaseMetadata(2, "TABLE_NAME", 1043)),
        GRANTOR(new BaseMetadata(3, "GRANTOR", 1043)),
        GRANTEE(new BaseMetadata(4, "GRANTEE", 1043)),
        PRIVILEGE(new BaseMetadata(5, "PRIVILEGE", 1043)),
        IS_GRANTABLE(new BaseMetadata(6, "IS_GRANTABLE", 1043));

        private final BaseMetadata metadata;

        private GetTablePrivileges_Metadata(BaseMetadata metadata) {
            this.metadata = metadata;
        }

        @Override
        public int getIndex() {
            return this.metadata.getIndex();
        }

        @Override
        public String getName() {
            return this.metadata.getName();
        }

        @Override
        public int getOidType() {
            return this.metadata.getOidType();
        }
    }

    public static enum GetColumnPrivileges_Metadata implements enumFunc<GetColumnPrivileges_Metadata>
    {
        TABLE_CAT(new BaseMetadata(0, "TABLE_CAT", 1043)),
        TABLE_SCHEM(new BaseMetadata(1, "TABLE_SCHEM", 1043)),
        TABLE_NAME(new BaseMetadata(2, "TABLE_NAME", 1043)),
        COLUMN_NAME(new BaseMetadata(3, "COLUMN_NAME", 1043)),
        GRANTOR(new BaseMetadata(4, "GRANTOR", 1043)),
        GRANTEE(new BaseMetadata(5, "GRANTEE", 1043)),
        PRIVILEGE(new BaseMetadata(6, "PRIVILEGE", 1043)),
        IS_GRANTABLE(new BaseMetadata(7, "IS_GRANTABLE", 1043));

        private final BaseMetadata metadata;

        private GetColumnPrivileges_Metadata(BaseMetadata metadata) {
            this.metadata = metadata;
        }

        @Override
        public int getIndex() {
            return this.metadata.getIndex();
        }

        @Override
        public String getName() {
            return this.metadata.getName();
        }

        @Override
        public int getOidType() {
            return this.metadata.getOidType();
        }
    }

    public static enum GetBestRowIdentifier_Metadata implements enumFunc<GetBestRowIdentifier_Metadata>
    {
        SCOPE(new BaseMetadata(0, "SCOPE", 21)),
        COLUMN_NAME(new BaseMetadata(1, "COLUMN_NAME", 1043)),
        DATA_TYPE(new BaseMetadata(2, "DATA_TYPE", 23)),
        TYPE_NAME(new BaseMetadata(3, "TYPE_NAME", 1043)),
        COLUMN_SIZE(new BaseMetadata(4, "COLUMN_SIZE", 23)),
        BUFFER_LENGTH(new BaseMetadata(5, "BUFFER_LENGTH", 23)),
        DECIMAL_DIGITS(new BaseMetadata(6, "DECIMAL_DIGITS", 21)),
        PSEUDO_COLUMN(new BaseMetadata(7, "PSEUDO_COLUMN", 21));

        private final BaseMetadata metadata;

        private GetBestRowIdentifier_Metadata(BaseMetadata metadata) {
            this.metadata = metadata;
        }

        @Override
        public int getIndex() {
            return this.metadata.getIndex();
        }

        @Override
        public String getName() {
            return this.metadata.getName();
        }

        @Override
        public int getOidType() {
            return this.metadata.getOidType();
        }
    }

    public static enum GetForeignKeys_Metadata implements enumFunc<GetForeignKeys_Metadata>
    {
        PKTABLE_CAT(new BaseMetadata(0, "PKTABLE_CAT", 1043)),
        PKTABLE_SCHEM(new BaseMetadata(1, "PKTABLE_SCHEM", 1043)),
        PKTABLE_NAME(new BaseMetadata(2, "PKTABLE_NAME", 1043)),
        PKCOLUMN_NAME(new BaseMetadata(3, "PKCOLUMN_NAME", 1043)),
        FKTABLE_CAT(new BaseMetadata(4, "FKTABLE_CAT", 1043)),
        FKTABLE_SCHEM(new BaseMetadata(5, "FKTABLE_SCHEM", 1043)),
        FKTABLE_NAME(new BaseMetadata(6, "FKTABLE_NAME", 1043)),
        FKCOLUMN_NAME(new BaseMetadata(7, "FKCOLUMN_NAME", 1043)),
        KEY_SEQ(new BaseMetadata(8, "KEY_SEQ", 21)),
        UPDATE_RULE(new BaseMetadata(9, "UPDATE_RULE", 21)),
        DELETE_RULE(new BaseMetadata(10, "DELETE_RULE", 21)),
        FK_NAME(new BaseMetadata(11, "FK_NAME", 1043)),
        PK_NAME(new BaseMetadata(12, "PK_NAME", 1043)),
        DEFERRABILITY(new BaseMetadata(13, "DEFERRABILITY", 21));

        private final BaseMetadata metadata;

        private GetForeignKeys_Metadata(BaseMetadata metadata) {
            this.metadata = metadata;
        }

        @Override
        public int getIndex() {
            return this.metadata.getIndex();
        }

        @Override
        public String getName() {
            return this.metadata.getName();
        }

        @Override
        public int getOidType() {
            return this.metadata.getOidType();
        }
    }

    public static enum GetPrimaryKeys_Metadata implements enumFunc<GetPrimaryKeys_Metadata>
    {
        TABLE_CAT(new BaseMetadata(0, "TABLE_CAT", 1043)),
        TABLE_SCHEM(new BaseMetadata(1, "TABLE_SCHEM", 1043)),
        TABLE_NAME(new BaseMetadata(2, "TABLE_NAME", 1043)),
        COLUMN_NAME(new BaseMetadata(3, "COLUMN_NAME", 1043)),
        KEY_SEQ(new BaseMetadata(4, "KEY_SEQ", 21)),
        PK_NAME(new BaseMetadata(5, "PK_NAME", 1043));

        private final BaseMetadata metadata;

        private GetPrimaryKeys_Metadata(BaseMetadata metadata) {
            this.metadata = metadata;
        }

        @Override
        public int getIndex() {
            return this.metadata.getIndex();
        }

        @Override
        public String getName() {
            return this.metadata.getName();
        }

        @Override
        public int getOidType() {
            return this.metadata.getOidType();
        }
    }

    public static enum GetColumns_Metadata implements enumFunc<GetColumns_Metadata>
    {
        TABLE_CAT(new BaseMetadata(0, "TABLE_CAT", 1043)),
        TABLE_SCHEM(new BaseMetadata(1, "TABLE_SCHEM", 1043)),
        TABLE_NAME(new BaseMetadata(2, "TABLE_NAME", 1043)),
        COLUMN_NAME(new BaseMetadata(3, "COLUMN_NAME", 1043)),
        DATA_TYPE(new BaseMetadata(4, "DATA_TYPE", 23)),
        TYPE_NAME(new BaseMetadata(5, "TYPE_NAME", 1043)),
        COLUMN_SIZE(new BaseMetadata(6, "COLUMN_SIZE", 23)),
        BUFFER_LENGTH(new BaseMetadata(7, "BUFFER_LENGTH", 23)),
        DECIMAL_DIGITS(new BaseMetadata(8, "DECIMAL_DIGITS", 23)),
        NUM_PREC_RADIX(new BaseMetadata(9, "NUM_PREC_RADIX", 23)),
        NULLABLE(new BaseMetadata(10, "NULLABLE", 23)),
        REMARKS(new BaseMetadata(11, "REMARKS", 1043)),
        COLUMN_DEF(new BaseMetadata(12, "COLUMN_DEF", 1043)),
        SQL_DATA_TYPE(new BaseMetadata(13, "SQL_DATA_TYPE", 23)),
        SQL_DATETIME_SUB(new BaseMetadata(14, "SQL_DATETIME_SUB", 23)),
        CHAR_OCTET_LENGTH(new BaseMetadata(15, "CHAR_OCTET_LENGTH", 23)),
        ORDINAL_POSITION(new BaseMetadata(16, "ORDINAL_POSITION", 23)),
        IS_NULLABLE(new BaseMetadata(17, "IS_NULLABLE", 1043)),
        SCOPE_CATALOG(new BaseMetadata(18, "SCOPE_CATALOG", 1043)),
        SCOPE_SCHEMA(new BaseMetadata(19, "SCOPE_SCHEMA", 1043)),
        SCOPE_TABLE(new BaseMetadata(20, "SCOPE_TABLE", 1043)),
        SOURCE_DATA_TYPE(new BaseMetadata(21, "SOURCE_DATA_TYPE", 21)),
        IS_AUTOINCREMENT(new BaseMetadata(22, "IS_AUTOINCREMENT", 1043)),
        IS_GENERATEDCOLUMN(new BaseMetadata(23, "IS_GENERATEDCOLUMN", 1043)),
        SORT_KEY_TYPE(new BaseMetadata(24, "SORT_KEY_TYPE", 1043)),
        SORT_KEY(new BaseMetadata(25, "SORT_KEY", 23)),
        DIST_KEY(new BaseMetadata(26, "DIST_KEY", 23)),
        ENCODING(new BaseMetadata(27, "ENCODING", 1043)),
        COLLATION(new BaseMetadata(28, "COLLATION", 1043));

        private final BaseMetadata metadata;

        private GetColumns_Metadata(BaseMetadata metadata) {
            this.metadata = metadata;
        }

        @Override
        public int getIndex() {
            return this.metadata.getIndex();
        }

        @Override
        public String getName() {
            return this.metadata.getName();
        }

        @Override
        public int getOidType() {
            return this.metadata.getOidType();
        }
    }

    public static enum GetTables_Metadata implements enumFunc<GetTables_Metadata>
    {
        TABLE_CAT(new BaseMetadata(0, "TABLE_CAT", 1043)),
        TABLE_SCHEM(new BaseMetadata(1, "TABLE_SCHEM", 1043)),
        TABLE_NAME(new BaseMetadata(2, "TABLE_NAME", 1043)),
        TABLE_TYPE(new BaseMetadata(3, "TABLE_TYPE", 1043)),
        REMARKS(new BaseMetadata(4, "REMARKS", 1043)),
        TYPE_CAT(new BaseMetadata(5, "TYPE_CAT", 1043)),
        TYPE_SCHEM(new BaseMetadata(6, "TYPE_SCHEM", 1043)),
        TYPE_NAME(new BaseMetadata(7, "TYPE_NAME", 1043)),
        SELF_REFERENCING_COL_NAME(new BaseMetadata(8, "SELF_REFERENCING_COL_NAME", 1043)),
        REF_GENERATION(new BaseMetadata(9, "REF_GENERATION", 1043)),
        OWNER(new BaseMetadata(10, "OWNER", 1043)),
        LAST_ALTERED_TIME(new BaseMetadata(11, "LAST_ALTERED_TIME", 1114)),
        LAST_MODIFIED_TIME(new BaseMetadata(12, "LAST_MODIFIED_TIME", 1114)),
        DIST_STYLE(new BaseMetadata(13, "DIST_STYLE", 1043)),
        TABLE_SUBTYPE(new BaseMetadata(14, "TABLE_SUBTYPE", 1043));

        private final BaseMetadata metadata;

        private GetTables_Metadata(BaseMetadata metadata) {
            this.metadata = metadata;
        }

        @Override
        public int getIndex() {
            return this.metadata.getIndex();
        }

        @Override
        public String getName() {
            return this.metadata.getName();
        }

        @Override
        public int getOidType() {
            return this.metadata.getOidType();
        }
    }

    public static enum GetSchemas_Metadata implements enumFunc<GetSchemas_Metadata>
    {
        TABLE_SCHEM(new BaseMetadata(0, "TABLE_SCHEM", 1043)),
        TABLE_CATALOG(new BaseMetadata(1, "TABLE_CATALOG", 1043));

        private final BaseMetadata metadata;

        private GetSchemas_Metadata(BaseMetadata metadata) {
            this.metadata = metadata;
        }

        @Override
        public int getIndex() {
            return this.metadata.getIndex();
        }

        @Override
        public String getName() {
            return this.metadata.getName();
        }

        @Override
        public int getOidType() {
            return this.metadata.getOidType();
        }
    }

    public static enum GetCatalogs_Metadata implements enumFunc<GetCatalogs_Metadata>
    {
        TABLE_CAT(new BaseMetadata(0, "TABLE_CAT", 1043));

        private final BaseMetadata metadata;

        private GetCatalogs_Metadata(BaseMetadata metadata) {
            this.metadata = metadata;
        }

        @Override
        public int getIndex() {
            return this.metadata.getIndex();
        }

        @Override
        public String getName() {
            return this.metadata.getName();
        }

        @Override
        public int getOidType() {
            return this.metadata.getOidType();
        }
    }

    private static class BaseMetadata {
        private final int colIndex;
        private final String colName;
        private final int colOidType;

        BaseMetadata(int colIndex, String colName, int colOidType) {
            this.colIndex = colIndex;
            this.colName = colName;
            this.colOidType = colOidType;
        }

        public int getIndex() {
            return this.colIndex;
        }

        public String getName() {
            return this.colName;
        }

        public int getOidType() {
            return this.colOidType;
        }
    }

    protected static enum ForeignKeyColumnIndex {
        PK_CATALOG(0),
        PK_SCHEMA(1),
        PK_TABLE(2),
        PK_COLUMN(3),
        FK_CATALOG(4),
        FK_SCHEMA(5),
        FK_TABLE(6),
        FK_COLUMN(7),
        KEY_SEQ(8);

        private final int index;

        private ForeignKeyColumnIndex(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }
    }

    protected static class RedshiftDataTypes {
        private static final Set<String> VALID_TYPES = new HashSet<String>(Arrays.asList("smallint", "int2", "integer", "int", "int4", "bigint", "int8", "decimal", "numeric", "real", "float4", "double precision", "float8", "float", "char", "character", "nchar", "bpchar", "varchar", "character varying", "nvarchar", "text", "date", "time", "time without time zone", "timetz", "time with time zone", "timestamp", "timestamp without time zone", "timestamptz", "timestamp with time zone", "intervaly2m", "interval year to month", "intervald2s", "interval day to second", "boolean", "bool", "hllsketch", "super", "varbyte", "varbinary", "binary varying", "geometry", "geography", "oid", "smallint[]", "pg_attribute", "pg_type", "refcursor"));

        protected RedshiftDataTypes() {
        }

        private static boolean isValidType(String dataType) {
            return dataType != null && VALID_TYPES.contains(dataType.toLowerCase());
        }

        private static List<String> validateTypes(List<String> dataTypes) {
            return dataTypes.stream().filter(type -> !RedshiftDataTypes.isValidType(type)).collect(Collectors.toList());
        }
    }

    public static class BestRowIdenData {
        private final HashSet<String> pkColumnSet;
        private final List<ShowColumnsInfo> resultSet;

        public BestRowIdenData(List<ShowColumnsInfo> resultSet, HashSet<String> pkColumnSet) {
            this.resultSet = resultSet;
            this.pkColumnSet = pkColumnSet;
        }

        public HashSet<String> getPkColumnSet() {
            return this.pkColumnSet;
        }

        public List<ShowColumnsInfo> getResultSet() {
            return this.resultSet;
        }
    }

    protected static class ProcedureFunctionColumnData {
        private final String specificName;
        private final List<ShowParametersInfo> resultSet;

        public ProcedureFunctionColumnData(String specificName, List<ShowParametersInfo> resultSet) {
            this.specificName = specificName;
            this.resultSet = resultSet;
        }

        public String getSpecificName() {
            return this.specificName;
        }

        public List<ShowParametersInfo> getResultSet() {
            return this.resultSet;
        }
    }
}

