/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphicsio.emf.gdi;

import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import org.freehep.graphicsio.emf.EMFInputStream;
import org.freehep.graphicsio.emf.EMFOutputStream;
import org.freehep.graphicsio.emf.EMFTag;
import org.freehep.graphicsio.emf.gdi.AbstractPolyPolygon;

public class PolyPolygon
extends AbstractPolyPolygon {
    private int start;
    private int end;

    public PolyPolygon() {
        super(8, 1, null, null, null);
    }

    public PolyPolygon(Rectangle bounds, int start, int end, int[] numberOfPoints, Point[][] points) {
        super(8, 1, bounds, numberOfPoints, points);
        this.start = start;
        this.end = end;
    }

    @Override
    public EMFTag read(int tagID, EMFInputStream emf, int len) throws IOException {
        int i;
        Rectangle bounds = emf.readRECTL();
        int np = emf.readDWORD();
        emf.readDWORD();
        int[] pc = new int[np];
        Point[][] points = new Point[np][];
        for (i = 0; i < np; ++i) {
            pc[i] = emf.readDWORD();
            points[i] = new Point[pc[i]];
        }
        for (i = 0; i < np; ++i) {
            points[i] = emf.readPOINTL(pc[i]);
        }
        return new PolyPolygon(bounds, 0, np - 1, pc, points);
    }

    @Override
    public void write(int tagID, EMFOutputStream emf) throws IOException {
        int i;
        int[] numberOfPoints = this.getNumberOfPoints();
        Point[][] points = this.getPoints();
        emf.writeRECTL(this.getBounds());
        emf.writeDWORD(this.end - this.start + 1);
        int c = 0;
        for (i = this.start; i < this.end + 1; ++i) {
            c += numberOfPoints[i];
        }
        emf.writeDWORD(c);
        for (i = this.start; i < this.end + 1; ++i) {
            emf.writeDWORD(numberOfPoints[i]);
        }
        for (i = this.start; i < this.end + 1; ++i) {
            emf.writePOINTL(numberOfPoints[i], points[i]);
        }
    }
}

