/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.view.widgets;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.parosproxy.paros.control.Control;
import org.zaproxy.zap.extension.users.ExtensionUserManagement;
import org.zaproxy.zap.users.User;

public class UsersMultiSelectTable
extends JTable {
    private static final long serialVersionUID = 7473652413044348214L;
    private static ExtensionUserManagement usersExtension;
    private UsersSelectTableModel tableModel;

    public UsersMultiSelectTable(int contextId) {
        UsersMultiSelectTable.loadUsersManagementExtension();
        this.setTableHeader(null);
        this.reloadUsers(contextId);
        this.getColumnModel().getColumn(0).setMaxWidth(40);
    }

    private static void loadUsersManagementExtension() {
        if (usersExtension == null && (usersExtension = Control.getSingleton().getExtensionLoader().getExtension(ExtensionUserManagement.class)) == null) {
            throw new IllegalStateException("Trying to create MultiUserSelectBox without the ExtensionUsersManagement being enabled.");
        }
    }

    public void reloadUsers(int contextId) {
        ArrayList<User> users = new ArrayList<User>(usersExtension.getContextUserAuthManager(contextId).getUsers());
        this.tableModel = new UsersSelectTableModel(users);
        this.setModel(this.tableModel);
    }

    public List<User> getSelectedUsers() {
        return this.tableModel.generateSelectedUsers();
    }

    public int getSelectedUsersCount() {
        return this.tableModel.getSelectedUsersCount();
    }

    public void addCustomUser(User user) {
        this.tableModel.addUser(user);
    }

    private static class UsersSelectTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = -2187948264137599317L;
        private Set<Integer> selectedUsersIds;
        private List<User> users;

        public UsersSelectTableModel(List<User> users) {
            this.users = users;
            this.selectedUsersIds = new HashSet<Integer>(this.users.size());
        }

        public List<User> generateSelectedUsers() {
            ArrayList<User> selectedUsers = new ArrayList<User>(this.selectedUsersIds.size());
            for (User u : this.users) {
                if (!this.selectedUsersIds.contains(u.getId())) continue;
                selectedUsers.add(u);
            }
            return selectedUsers;
        }

        public int getSelectedUsersCount() {
            return this.selectedUsersIds.size();
        }

        public void addUser(User u) {
            this.users.add(u);
            this.fireTableRowsInserted(this.users.size() - 1, this.users.size() - 1);
        }

        @Override
        public int getRowCount() {
            return this.users.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return this.selectedUsersIds.contains(this.users.get(rowIndex).getId());
                }
                case 1: {
                    return this.users.get(rowIndex).getName();
                }
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return Boolean.class;
                }
                case 1: {
                    return String.class;
                }
            }
            return super.getColumnClass(columnIndex);
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return columnIndex == 0;
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 0 && aValue instanceof Boolean) {
                if (((Boolean)aValue).booleanValue()) {
                    this.selectedUsersIds.add(this.users.get(rowIndex).getId());
                } else {
                    this.selectedUsersIds.remove(this.users.get(rowIndex).getId());
                }
                this.fireTableCellUpdated(rowIndex, columnIndex);
            }
        }
    }
}

