/*
 * Decompiled with CFR 0.152.
 */
package org.xmlresolver.catalog.entry;

import java.net.URI;
import org.xmlresolver.ResolverConfiguration;
import org.xmlresolver.catalog.entry.Entry;
import org.xmlresolver.catalog.entry.EntryResource;

public class EntryUri
extends EntryResource {
    public final String name;
    public final String nature;
    public final String purpose;

    public EntryUri(ResolverConfiguration config, URI baseURI, String id, String name, String uri, String nature, String purpose) {
        super(config, baseURI, id, uri);
        this.name = name.startsWith("classpath:/") ? "classpath:" + name.substring(11) : name;
        this.nature = nature;
        this.purpose = purpose;
    }

    @Override
    public Entry.Type getType() {
        return Entry.Type.URI;
    }

    public String toString() {
        String str = "uri " + this.name + Entry.rarr + this.uri;
        if (this.nature != null || this.purpose != null) {
            str = str + " (";
            if (this.nature != null) {
                str = str + "nature=" + this.nature;
            }
            if (this.nature != null && this.purpose != null) {
                str = str + "; ";
            }
            if (this.purpose != null) {
                str = str + "purpose=" + this.purpose;
            }
            str = str + ")";
        }
        return str;
    }
}

