/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.network.proxy.pac.datetime;

import java.util.Calendar;

class DateRange {
    private static final int UNDEFINED = -1;
    private final int yearMin;
    private final int yearMax;
    private final int monthMin;
    private final int monthMax;
    private final int dateMin;
    private final int dateMax;

    public DateRange(int yearMin, int yearMax, int monthMin, int monthMax, int dateMin, int dateMax) {
        this.yearMin = yearMin;
        this.yearMax = yearMax == -1 && yearMin != -1 ? yearMin : yearMax;
        this.monthMin = monthMin;
        this.monthMax = monthMax == -1 && monthMin != -1 ? monthMin : monthMax;
        this.dateMin = dateMin;
        this.dateMax = dateMax == -1 && dateMin != -1 ? dateMin : dateMax;
    }

    public boolean isInRange(Calendar cal) {
        int year = cal.get(1);
        int month = cal.get(2);
        int date = cal.get(5);
        if (this.yearDefined() && (year < this.yearMin || year > this.yearMax)) {
            return false;
        }
        if (this.monthDefined()) {
            if (this.yearDefined()) {
                if (year == this.yearMin && month < this.monthMin) {
                    return false;
                }
                if (year == this.yearMax && month > this.monthMax) {
                    return false;
                }
            } else if (this.monthMin <= this.monthMax ? month < this.monthMin || month > this.monthMax : month < this.monthMin && month > this.monthMax) {
                return false;
            }
        }
        if (this.dateDefined()) {
            boolean checkDateRange = false;
            if (this.monthDefined()) {
                if (this.yearDefined()) {
                    if (year == this.yearMin && month == this.monthMin || year == this.yearMax && month == this.monthMax) {
                        checkDateRange = true;
                    }
                } else if (month == this.monthMin || month == this.monthMax) {
                    checkDateRange = true;
                }
            } else {
                checkDateRange = true;
            }
            if (checkDateRange && (this.dateMin <= this.dateMax ? date < this.dateMin || date > this.dateMax : date < this.dateMin && date > this.dateMax)) {
                return false;
            }
        }
        return true;
    }

    private boolean yearDefined() {
        return this.yearMin != -1 || this.yearMax != -1;
    }

    private boolean monthDefined() {
        return this.monthMin != -1 || this.monthMax != -1;
    }

    private boolean dateDefined() {
        return this.dateMin != -1 || this.dateMax != -1;
    }

    public static DateRangeBuilder getBuilder() {
        return new DateRangeBuilder();
    }

    public static class DateRangeBuilder {
        private int yearMin = -1;
        private int yearMax = -1;
        private int monthMin = -1;
        private int monthMax = -1;
        private int dateMin = -1;
        private int dateMax = -1;

        private DateRangeBuilder() {
        }

        public DateRangeBuilder setYear(int yearMin, int yearMax) {
            this.yearMin = yearMin;
            this.yearMax = yearMax;
            return this;
        }

        public DateRangeBuilder setMonth(int monthMin, int monthMax) {
            this.monthMin = monthMin;
            this.monthMax = monthMax;
            return this;
        }

        public DateRangeBuilder setDate(int dateMin, int dateMax) {
            this.dateMin = dateMin;
            this.dateMax = dateMax;
            return this;
        }

        public DateRange createDateRange() {
            return new DateRange(this.yearMin, this.yearMax, this.monthMin, this.monthMax, this.dateMin, this.dateMax);
        }
    }
}

