/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki.internal.pkcs12;

import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import oracle.security.pki.internal.asn1.ASN1FormatException;
import oracle.security.pki.internal.asn1.ASN1Object;
import oracle.security.pki.internal.asn1.ASN1ObjectID;
import oracle.security.pki.internal.asn1.ASN1OctetString;
import oracle.security.pki.internal.asn1.ASN1Sequence;
import oracle.security.pki.internal.asn1.ASN1Set;
import oracle.security.pki.internal.asn1.ASN1String;
import oracle.security.pki.internal.asn1.ASN1Utils;
import oracle.security.pki.internal.pkcs12.PKCS12CRLBag;
import oracle.security.pki.internal.pkcs12.PKCS12CertBag;
import oracle.security.pki.internal.pkcs12.PKCS12KeyBag;
import oracle.security.pki.internal.pkcs12.PKCS12Safe;
import oracle.security.pki.internal.pkcs12.PKCS12SafeContentsBag;
import oracle.security.pki.internal.pkcs12.PKCS12SecretBag;
import oracle.security.pki.internal.pkcs12.PKCS12ShroudedKeyBag;
import oracle.security.pki.util.Utils;

public abstract class PKCS12Bag
implements Externalizable,
ASN1Object {
    String a;
    byte[] b;

    protected PKCS12Bag() {
    }

    public static PKCS12Bag a(PKCS12Safe pKCS12Safe, InputStream inputStream) throws IOException {
        return PKCS12Bag.a(pKCS12Safe, new ASN1Sequence(inputStream));
    }

    static PKCS12Bag a(PKCS12Safe pKCS12Safe, ASN1Sequence aSN1Sequence) throws IOException {
        try {
            ASN1ObjectID aSN1ObjectID = (ASN1ObjectID)aSN1Sequence.a(0);
            PKCS12Bag pKCS12Bag = null;
            if (aSN1ObjectID.equals(new ASN1ObjectID(ASN1Utils.e, 12, 10, 1, 1))) {
                pKCS12Bag = new PKCS12KeyBag(pKCS12Safe, aSN1Sequence);
            } else if (aSN1ObjectID.equals(new ASN1ObjectID(ASN1Utils.e, 12, 10, 1, 2))) {
                pKCS12Bag = new PKCS12ShroudedKeyBag(pKCS12Safe, aSN1Sequence);
            } else if (aSN1ObjectID.equals(new ASN1ObjectID(ASN1Utils.e, 12, 10, 1, 3))) {
                pKCS12Bag = new PKCS12CertBag(pKCS12Safe, aSN1Sequence);
            } else if (aSN1ObjectID.equals(new ASN1ObjectID(ASN1Utils.e, 12, 10, 1, 4))) {
                pKCS12Bag = new PKCS12CRLBag(pKCS12Safe, aSN1Sequence);
            } else if (aSN1ObjectID.equals(new ASN1ObjectID(ASN1Utils.e, 12, 10, 1, 5))) {
                pKCS12Bag = new PKCS12SecretBag(pKCS12Safe, aSN1Sequence);
            } else if (aSN1ObjectID.equals(new ASN1ObjectID(ASN1Utils.e, 12, 10, 1, 6))) {
                pKCS12Bag = new PKCS12SafeContentsBag(pKCS12Safe, aSN1Sequence);
            } else {
                throw new IOException("Unknown PKCS#12 bag type: " + aSN1ObjectID);
            }
            if (aSN1Sequence.c() > 2) {
                ASN1Set aSN1Set = (ASN1Set)aSN1Sequence.a(2);
                ArrayList<ASN1Object> arrayList = aSN1Set.b();
                int n = arrayList.size();
                for (int i = 0; i < n; ++i) {
                    Object object;
                    ASN1Set aSN1Set2;
                    ASN1Sequence aSN1Sequence2 = (ASN1Sequence)arrayList.get(i);
                    ASN1ObjectID aSN1ObjectID2 = (ASN1ObjectID)aSN1Sequence2.a(0);
                    if (aSN1ObjectID2.a(ASN1Utils.e, 9, 20)) {
                        aSN1Set2 = (ASN1Set)aSN1Sequence2.a(1);
                        object = ((ASN1String)aSN1Set2.a(0)).b();
                        pKCS12Bag.a((String)object);
                        continue;
                    }
                    if (!aSN1ObjectID2.a(ASN1Utils.e, 9, 21)) continue;
                    aSN1Set2 = (ASN1Set)aSN1Sequence2.a(1);
                    object = ((ASN1OctetString)aSN1Set2.a(0)).b();
                    pKCS12Bag.a((byte[])object);
                }
            }
            return pKCS12Bag;
        }
        catch (ClassCastException classCastException) {
            throw new ASN1FormatException(classCastException.toString());
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new ASN1FormatException(indexOutOfBoundsException.toString());
        }
    }

    abstract void a();

    public String b() {
        return this.a;
    }

    public void a(String string) {
        this.a = string;
        this.a();
    }

    public byte[] c() {
        return this.b;
    }

    public void a(byte[] byArray) {
        this.b = byArray;
        this.a();
    }

    public ASN1Set d() {
        ASN1Set aSN1Set;
        ASN1Sequence aSN1Sequence;
        ASN1Set aSN1Set2 = new ASN1Set();
        if (this.a != null) {
            aSN1Sequence = new ASN1Sequence();
            aSN1Sequence.a(new ASN1ObjectID(ASN1Utils.e, 9, 20));
            aSN1Set = new ASN1Set();
            aSN1Set.a(new ASN1String(this.a, 30));
            aSN1Sequence.a(aSN1Set);
            aSN1Set2.a(aSN1Sequence);
        }
        if (this.b != null) {
            aSN1Sequence = new ASN1Sequence();
            aSN1Sequence.a(new ASN1ObjectID(ASN1Utils.e, 9, 21));
            aSN1Set = new ASN1Set();
            aSN1Set.a(new ASN1OctetString(this.b));
            aSN1Sequence.a(aSN1Set);
            aSN1Set2.a(aSN1Sequence);
        }
        if (aSN1Set2.b().size() > 0) {
            return aSN1Set2;
        }
        return null;
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeObject(Utils.toBytes(this));
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        byte[] byArray;
        try {
            byArray = (byte[])objectInput.readObject();
        }
        catch (ClassCastException classCastException) {
            throw new IOException(classCastException);
        }
        this.input(new ByteArrayInputStream(byArray));
    }
}

