/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.rest.schema;

import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.solr.common.SolrException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class FieldTypeXmlAdapter {
    public static Node toNode(Map<String, ?> json) {
        Element similarity;
        DocumentBuilder docBuilder;
        try {
            docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, (Throwable)e);
        }
        Document doc = docBuilder.newDocument();
        Element fieldType = doc.createElement("fieldType");
        FieldTypeXmlAdapter.appendAttrs(fieldType, json);
        Element analyzer = FieldTypeXmlAdapter.transformAnalyzer(doc, json, "analyzer", null);
        if (analyzer != null) {
            fieldType.appendChild(analyzer);
        }
        if ((analyzer = FieldTypeXmlAdapter.transformAnalyzer(doc, json, "indexAnalyzer", "index")) != null) {
            fieldType.appendChild(analyzer);
        }
        if ((analyzer = FieldTypeXmlAdapter.transformAnalyzer(doc, json, "queryAnalyzer", "query")) != null) {
            fieldType.appendChild(analyzer);
        }
        if ((analyzer = FieldTypeXmlAdapter.transformAnalyzer(doc, json, "multiTermAnalyzer", "multiterm")) != null) {
            fieldType.appendChild(analyzer);
        }
        if ((similarity = FieldTypeXmlAdapter.transformSimilarity(doc, json, "similarity")) != null) {
            fieldType.appendChild(similarity);
        }
        return fieldType;
    }

    protected static Element transformSimilarity(Document doc, Map<String, ?> json, String jsonFieldName) {
        Object jsonField = json.get(jsonFieldName);
        if (jsonField == null) {
            return null;
        }
        if (!(jsonField instanceof Map)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid fieldType definition! Expected JSON object for " + jsonFieldName + " not a " + jsonField.getClass().getName());
        }
        Element similarity = doc.createElement("similarity");
        Map config = (Map)jsonField;
        similarity.setAttribute("class", (String)config.remove("class"));
        for (Map.Entry entry : config.entrySet()) {
            Object val = entry.getValue();
            if (val == null) continue;
            Element child = doc.createElement(FieldTypeXmlAdapter.classToXmlTag(val.getClass()));
            child.setAttribute("name", (String)entry.getKey());
            child.setTextContent(entry.getValue().toString());
            similarity.appendChild(child);
        }
        return similarity;
    }

    protected static String classToXmlTag(Class<?> clazz) {
        switch (clazz.getSimpleName()) {
            case "Boolean": {
                return "bool";
            }
            case "Double": {
                return "double";
            }
            case "Long": {
                return "long";
            }
            case "String": {
                return "str";
            }
        }
        throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Unsupported object type '" + clazz.getSimpleName() + "'");
    }

    protected static Element transformAnalyzer(Document doc, Map<String, ?> json, String jsonFieldName, String analyzerType) {
        Object jsonField = json.get(jsonFieldName);
        if (jsonField == null) {
            return null;
        }
        if (!(jsonField instanceof Map)) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Invalid fieldType definition! Expected JSON object for " + jsonFieldName + " not a " + jsonField.getClass().getName());
        }
        return FieldTypeXmlAdapter.createAnalyzerElement(doc, analyzerType, (Map)jsonField);
    }

    protected static Element createAnalyzerElement(Document doc, String type, Map<String, ?> analyzer) {
        Element analyzerElem = FieldTypeXmlAdapter.appendAttrs(doc.createElement("analyzer"), analyzer);
        if (type != null) {
            analyzerElem.setAttribute("type", type);
        }
        List charFilters = (List)analyzer.get("charFilters");
        Map tokenizer = (Map)analyzer.get("tokenizer");
        List filters = (List)analyzer.get("filters");
        if (analyzer.get("class") == null) {
            if (charFilters != null) {
                FieldTypeXmlAdapter.appendFilterElements(doc, analyzerElem, "charFilter", charFilters);
            }
            if (tokenizer == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Analyzer must define a tokenizer!");
            }
            if (tokenizer.get("class") == null && tokenizer.get("name") == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Every tokenizer must define a class or name property!");
            }
            analyzerElem.appendChild(FieldTypeXmlAdapter.appendAttrs(doc.createElement("tokenizer"), tokenizer));
            if (filters != null) {
                FieldTypeXmlAdapter.appendFilterElements(doc, analyzerElem, "filter", filters);
            }
        } else {
            if (charFilters != null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "An analyzer with a class property may not define any char filters!");
            }
            if (tokenizer != null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "An analyzer with a class property may not define a tokenizer!");
            }
            if (filters != null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "An analyzer with a class property may not define any filters!");
            }
        }
        return analyzerElem;
    }

    protected static void appendFilterElements(Document doc, Element analyzer, String filterName, List<Map<String, ?>> filters) {
        for (Map<String, ?> next : filters) {
            String filterClass = (String)next.get("class");
            String filterSPIName = (String)next.get("name");
            if (filterClass == null && filterSPIName == null) {
                throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Every " + filterName + " must define a class or name property!");
            }
            analyzer.appendChild(FieldTypeXmlAdapter.appendAttrs(doc.createElement(filterName), next));
        }
    }

    protected static Element appendAttrs(Element elm, Map<String, ?> json) {
        for (Map.Entry<String, ?> entry : json.entrySet()) {
            Object val = entry.getValue();
            if (val == null || val instanceof Map) continue;
            elm.setAttribute(entry.getKey(), val.toString());
        }
        return elm;
    }
}

