/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.io;

import com.eteks.sweethome3d.io.Base64;
import com.eteks.sweethome3d.io.ContentDigestManager;
import com.eteks.sweethome3d.io.ContentRecording;
import com.eteks.sweethome3d.io.HomeURLContent;
import com.eteks.sweethome3d.io.HomeXMLExporter;
import com.eteks.sweethome3d.io.XMLWriter;
import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.tools.ResourceURLContent;
import com.eteks.sweethome3d.tools.SimpleURLContent;
import com.eteks.sweethome3d.tools.TemporaryURLContent;
import com.eteks.sweethome3d.tools.URLContent;
import java.io.File;
import java.io.FilterOutputStream;
import java.io.FilterWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class DefaultHomeOutputStream
extends FilterOutputStream {
    private int compressionLevel;
    private ContentRecording contentRecording;
    private boolean serializedHome;
    private HomeXMLExporter homeXmlExporter;

    public DefaultHomeOutputStream(OutputStream outputStream) throws IOException {
        this(outputStream, 0, false);
    }

    public DefaultHomeOutputStream(OutputStream outputStream, int n, boolean bl) throws IOException {
        this(outputStream, n, bl ? ContentRecording.INCLUDE_TEMPORARY_CONTENT : ContentRecording.INCLUDE_ALL_CONTENT);
    }

    public DefaultHomeOutputStream(OutputStream outputStream, int n, ContentRecording contentRecording) throws IOException {
        this(outputStream, n, contentRecording, true, null);
    }

    public DefaultHomeOutputStream(OutputStream outputStream, int n, ContentRecording contentRecording, boolean bl, HomeXMLExporter homeXMLExporter) throws IOException {
        super(outputStream);
        if (!bl && homeXMLExporter == null) {
            throw new IllegalArgumentException("No entry specified for home data");
        }
        this.compressionLevel = n;
        this.contentRecording = contentRecording;
        this.serializedHome = bl;
        this.homeXmlExporter = homeXMLExporter;
    }

    private static void checkCurrentThreadIsntInterrupted() throws InterruptedIOException {
        if (Thread.interrupted()) {
            throw new InterruptedIOException();
        }
    }

    public void writeHome(Home home) throws IOException {
        Object object;
        ZipOutputStream zipOutputStream = new ZipOutputStream(this.out);
        zipOutputStream.setLevel(this.compressionLevel);
        DefaultHomeOutputStream.checkCurrentThreadIsntInterrupted();
        HomeContentObjectsTracker homeContentObjectsTracker = new HomeContentObjectsTracker(new OutputStream(){

            @Override
            public void write(int n) throws IOException {
            }
        });
        homeContentObjectsTracker.writeObject(home);
        Map<Content, String> map = homeContentObjectsTracker.getSavedContentNames();
        if (this.serializedHome) {
            zipOutputStream.putNextEntry(new ZipEntry("Home"));
            object = new HomeObjectOutputStream(zipOutputStream, map);
            ((ObjectOutputStream)object).writeObject(home);
            ((ObjectOutputStream)object).flush();
            zipOutputStream.closeEntry();
        }
        if (this.homeXmlExporter != null) {
            zipOutputStream.putNextEntry(new ZipEntry("Home.xml"));
            object = new XMLWriter(zipOutputStream);
            this.homeXmlExporter.setSavedContentNames(map);
            this.homeXmlExporter.writeElement((XMLWriter)object, home);
            ((FilterWriter)object).flush();
            zipOutputStream.closeEntry();
        }
        if (map.size() > 0) {
            String string;
            object = new HashSet();
            zipOutputStream.putNextEntry(new ZipEntry("ContentDigests"));
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)zipOutputStream, "UTF-8");
            ContentDigestManager contentDigestManager = ContentDigestManager.getInstance();
            outputStreamWriter.write("ContentDigests-Version: 1.0\n\n");
            for (Map.Entry<Content, String> entry : map.entrySet()) {
                string = entry.getValue();
                if (object.contains(string)) continue;
                object.add(string);
                outputStreamWriter.write("Name: " + string + "\n");
                outputStreamWriter.write("SHA-1-Digest: " + Base64.encodeBytes(contentDigestManager.getContentDigest(entry.getKey())) + "\n\n");
            }
            outputStreamWriter.flush();
            zipOutputStream.closeEntry();
            object.clear();
            for (Map.Entry<Content, String> entry : map.entrySet()) {
                string = entry.getValue();
                if (object.contains(string)) continue;
                object.add(string);
                Content content = entry.getKey();
                int n = string.indexOf(47);
                if (n > 0) {
                    string = string.substring(0, n);
                }
                if (content instanceof ResourceURLContent) {
                    this.writeResourceZipEntries(zipOutputStream, string, (ResourceURLContent)content);
                    continue;
                }
                if (content instanceof URLContent && !(content instanceof SimpleURLContent) && ((URLContent)content).isJAREntry()) {
                    URLContent uRLContent = (URLContent)content;
                    if (uRLContent instanceof HomeURLContent) {
                        this.writeHomeZipEntries(zipOutputStream, string, (HomeURLContent)uRLContent);
                        continue;
                    }
                    this.writeZipEntries(zipOutputStream, string, uRLContent);
                    continue;
                }
                this.writeZipEntry(zipOutputStream, string, content);
            }
        }
        zipOutputStream.finish();
    }

    private void writeResourceZipEntries(ZipOutputStream zipOutputStream, String string, ResourceURLContent resourceURLContent) throws IOException {
        if (resourceURLContent.isMultiPartResource()) {
            if (resourceURLContent.isJAREntry()) {
                URL uRL = resourceURLContent.getJAREntryURL();
                String string2 = resourceURLContent.getJAREntryName();
                int n = string2.lastIndexOf(47);
                if (n != -1) {
                    String string3 = string2.substring(0, n + 1);
                    for (ContentDigestManager.ZipEntryData zipEntryData : ContentDigestManager.getInstance().getZipURLEntries(resourceURLContent)) {
                        String string4 = zipEntryData.getName();
                        if (!string4.startsWith(string3)) continue;
                        URLContent uRLContent = new URLContent(new URL("jar:" + uRL + "!/" + URLEncoder.encode(string4, "UTF-8").replace("+", "%20")));
                        this.writeZipEntry(zipOutputStream, string + string4.substring(n), uRLContent);
                    }
                } else {
                    this.writeZipEntry(zipOutputStream, string, resourceURLContent);
                }
            } else {
                try {
                    File[] fileArray;
                    File file = new File(resourceURLContent.getURL().toURI());
                    File file2 = new File(file.getParent());
                    for (File file3 : fileArray = file2.listFiles()) {
                        if (file3.isDirectory()) continue;
                        this.writeZipEntry(zipOutputStream, string + "/" + file3.getName(), new URLContent(file3.toURI().toURL()));
                    }
                }
                catch (URISyntaxException uRISyntaxException) {
                    IOException iOException = new IOException();
                    iOException.initCause(uRISyntaxException);
                    throw iOException;
                }
            }
        } else {
            this.writeZipEntry(zipOutputStream, string, resourceURLContent);
        }
    }

    private void writeHomeZipEntries(ZipOutputStream zipOutputStream, String string, HomeURLContent homeURLContent) throws IOException {
        String string2 = homeURLContent.getJAREntryName();
        int n = string2.indexOf(47);
        if (n > 0) {
            URL uRL = homeURLContent.getJAREntryURL();
            String string3 = string2.substring(0, n + 1);
            for (ContentDigestManager.ZipEntryData zipEntryData : ContentDigestManager.getInstance().getZipURLEntries(homeURLContent)) {
                String string4 = zipEntryData.getName();
                if (!string4.startsWith(string3)) continue;
                URLContent uRLContent = new URLContent(new URL("jar:" + uRL + "!/" + URLEncoder.encode(string4, "UTF-8").replace("+", "%20")));
                this.writeZipEntry(zipOutputStream, string + string4.substring(n), uRLContent);
            }
        } else {
            this.writeZipEntry(zipOutputStream, string, homeURLContent);
        }
    }

    private void writeZipEntries(ZipOutputStream zipOutputStream, String string, URLContent uRLContent) throws IOException {
        for (ContentDigestManager.ZipEntryData zipEntryData : ContentDigestManager.getInstance().getZipURLEntries(uRLContent)) {
            String string2 = zipEntryData.getName();
            URLContent uRLContent2 = new URLContent(new URL("jar:" + uRLContent.getJAREntryURL() + "!/" + URLEncoder.encode(string2, "UTF-8").replace("+", "%20")));
            this.writeZipEntry(zipOutputStream, string + "/" + string2, uRLContent2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeZipEntry(ZipOutputStream zipOutputStream, String string, Content content) throws IOException {
        DefaultHomeOutputStream.checkCurrentThreadIsntInterrupted();
        byte[] byArray = new byte[8192];
        try (InputStream inputStream = null;){
            int n;
            zipOutputStream.putNextEntry(new ZipEntry(string));
            inputStream = content.openStream();
            while ((n = inputStream.read(byArray)) != -1) {
                zipOutputStream.write(byArray, 0, n);
            }
            zipOutputStream.closeEntry();
        }
    }

    private class HomeContentObjectsTracker
    extends ObjectOutputStream {
        private Map<Content, String> savedContentNames;
        private int savedContentIndex;

        public HomeContentObjectsTracker(OutputStream outputStream) throws IOException {
            super(outputStream);
            this.savedContentNames = new LinkedHashMap<Content, String>();
            this.savedContentIndex = 0;
            if (DefaultHomeOutputStream.this.contentRecording != ContentRecording.INCLUDE_NO_CONTENT) {
                this.enableReplaceObject(true);
            }
        }

        @Override
        protected Object replaceObject(Object object) throws IOException {
            if (object instanceof TemporaryURLContent || object instanceof HomeURLContent || object instanceof SimpleURLContent || DefaultHomeOutputStream.this.contentRecording == ContentRecording.INCLUDE_ALL_CONTENT && object instanceof Content) {
                Object object2;
                String string = "";
                if (object instanceof URLContent) {
                    Object object3;
                    object2 = (URLContent)object;
                    ContentDigestManager contentDigestManager = ContentDigestManager.getInstance();
                    Object object4 = this.savedContentNames.entrySet().iterator();
                    while (object4.hasNext()) {
                        object3 = object4.next();
                        if (!contentDigestManager.equals((Content)object2, object3.getKey())) continue;
                        this.savedContentNames.put((Content)object, object3.getValue());
                        return object;
                    }
                    DefaultHomeOutputStream.checkCurrentThreadIsntInterrupted();
                    if (((URLContent)object2).isJAREntry()) {
                        object4 = ((URLContent)object2).getJAREntryName();
                        if (object2 instanceof HomeURLContent) {
                            int n = ((String)object4).indexOf(47);
                            if (n > 0) {
                                string = ((String)object4).substring(n);
                            }
                        } else if (object2 instanceof ResourceURLContent) {
                            int n;
                            object3 = (ResourceURLContent)object2;
                            if (((ResourceURLContent)object3).isMultiPartResource() && (n = ((String)object4).lastIndexOf(47)) != -1) {
                                string = ((String)object4).substring(n);
                            }
                        } else if (!(object2 instanceof SimpleURLContent)) {
                            string = "/" + (String)object4;
                        }
                    } else if (object2 instanceof ResourceURLContent && ((ResourceURLContent)(object4 = (ResourceURLContent)object2)).isMultiPartResource()) {
                        try {
                            string = "/" + new File(((URLContent)object4).getURL().toURI()).getName();
                        }
                        catch (URISyntaxException uRISyntaxException) {
                            IOException iOException = new IOException();
                            iOException.initCause(uRISyntaxException);
                            throw iOException;
                        }
                    }
                }
                object2 = this.savedContentIndex++ + string;
                this.savedContentNames.put((Content)object, (String)object2);
            }
            return object;
        }

        public Map<Content, String> getSavedContentNames() {
            return this.savedContentNames;
        }
    }

    private class HomeObjectOutputStream
    extends ObjectOutputStream {
        private Map<Content, String> savedContentNames;
        private Map<String, URLContent> replacedContents;

        public HomeObjectOutputStream(OutputStream outputStream, Map<Content, String> map) throws IOException {
            super(outputStream);
            this.replacedContents = new HashMap<String, URLContent>();
            this.savedContentNames = map;
            if (DefaultHomeOutputStream.this.contentRecording != ContentRecording.INCLUDE_NO_CONTENT) {
                this.enableReplaceObject(true);
            }
        }

        @Override
        protected Object replaceObject(Object object) throws IOException {
            String string;
            if (object instanceof Content && (string = this.savedContentNames.get((Content)object)) != null) {
                DefaultHomeOutputStream.checkCurrentThreadIsntInterrupted();
                URLContent uRLContent = this.replacedContents.get(string);
                if (uRLContent == null) {
                    uRLContent = new URLContent(new URL("jar:file:temp!/" + string));
                    this.replacedContents.put(string, uRLContent);
                }
                return uRLContent;
            }
            return object;
        }
    }
}

